/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink.models;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;

@Entity
@Table(name="PRINCIPAL_SECRETS")
public class ModelPrincipalSecrets {
    private long principalId;
    @Id
    private String principalClientId;
    private String mainSecretHash;
    private String secondarySecretHash;
    private String secretSalt;
    @Version
    private long version;

    public long getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalClientId() {
        return this.principalClientId;
    }

    public String getSecretSalt() {
        return this.secretSalt;
    }

    public String getMainSecretHash() {
        return this.mainSecretHash;
    }

    public String getSecondarySecretHash() {
        return this.secondarySecretHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelPrincipalSecrets fromPrincipalSecrets(PolarisPrincipalSecrets record) {
        if (record == null) {
            return null;
        }
        return ModelPrincipalSecrets.builder().principalId(record.getPrincipalId()).principalClientId(record.getPrincipalClientId()).secretSalt(record.getSecretSalt()).mainSecretHash(record.getMainSecretHash()).secondarySecretHash(record.getSecondarySecretHash()).build();
    }

    public static PolarisPrincipalSecrets toPrincipalSecrets(ModelPrincipalSecrets model) {
        if (model == null) {
            return null;
        }
        return new PolarisPrincipalSecrets(model.getPrincipalId(), model.getPrincipalClientId(), null, null, model.getSecretSalt(), model.getMainSecretHash(), model.getSecondarySecretHash());
    }

    public void update(PolarisPrincipalSecrets principalSecrets) {
        if (principalSecrets == null) {
            return;
        }
        this.principalId = principalSecrets.getPrincipalId();
        this.principalClientId = principalSecrets.getPrincipalClientId();
        this.secretSalt = principalSecrets.getSecretSalt();
        this.mainSecretHash = principalSecrets.getMainSecretHash();
        this.secondarySecretHash = principalSecrets.getSecondarySecretHash();
    }

    public static final class Builder {
        private final ModelPrincipalSecrets principalSecrets = new ModelPrincipalSecrets();

        private Builder() {
        }

        public Builder principalId(long principalId) {
            this.principalSecrets.principalId = principalId;
            return this;
        }

        public Builder principalClientId(String principalClientId) {
            this.principalSecrets.principalClientId = principalClientId;
            return this;
        }

        public Builder secretSalt(String secretSalt) {
            this.principalSecrets.secretSalt = secretSalt;
            return this;
        }

        public Builder mainSecretHash(String mainSecretHash) {
            this.principalSecrets.mainSecretHash = mainSecretHash;
            return this;
        }

        public Builder secondarySecretHash(String secondarySecretHash) {
            this.principalSecrets.secondarySecretHash = secondarySecretHash;
            return this;
        }

        public ModelPrincipalSecrets build() {
            return this.principalSecrets;
        }
    }
}

