/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.tracing;

import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.service.logging.LoggingConfiguration;
import org.apache.polaris.service.tracing.RequestIdGenerator;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestIdFilter {
    public static final String REQUEST_ID_KEY = "requestId";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestIdFilter.class);
    @Inject
    LoggingConfiguration loggingConfiguration;
    @Inject
    RequestIdGenerator requestIdGenerator;

    @ServerRequestFilter(preMatching=true, priority=899)
    public Uni<Response> assignRequestId(ContainerRequestContext rc) {
        String requestId = rc.getHeaderString(this.loggingConfiguration.requestIdHeaderName());
        return (requestId != null ? Uni.createFrom().item((Object)requestId) : this.requestIdGenerator.generateRequestId(rc)).onItem().invoke(id -> rc.setProperty(REQUEST_ID_KEY, id)).onItemOrFailure().transform((id, error) -> error == null ? null : RequestIdFilter.errorResponse(error));
    }

    @ServerResponseFilter
    public void addResponseHeader(ContainerRequestContext request, ContainerResponseContext response) {
        String requestId = (String)request.getProperty(REQUEST_ID_KEY);
        if (requestId != null) {
            response.getHeaders().add((Object)this.loggingConfiguration.requestIdHeaderName(), (Object)requestId);
        }
    }

    private static Response errorResponse(Throwable error) {
        LOGGER.error("Failed to generate request ID", error);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ErrorResponse.builder().responseCode(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage("Request ID generation failed").withType("RequestIdGenerationError").build()).build();
    }
}

