/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.events.listeners;

import jakarta.annotation.Nullable;
import java.util.Map;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.service.events.CatalogsServiceEvents;
import org.apache.polaris.service.events.IcebergRestCatalogEvents;
import org.apache.polaris.service.events.PolarisEvent;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

public abstract class PolarisPersistenceEventListener
implements PolarisEventListener {
    @Override
    public void onAfterCreateTable(IcebergRestCatalogEvents.AfterCreateTableEvent event) {
        ContextSpecificInformation contextSpecificInformation = this.getContextSpecificInformation();
        TableMetadata tableMetadata = event.loadTableResponse().tableMetadata();
        org.apache.polaris.core.entity.PolarisEvent polarisEvent = new org.apache.polaris.core.entity.PolarisEvent(event.catalogName(), PolarisEvent.createEventId(), this.getRequestId(), event.getClass().getSimpleName(), contextSpecificInformation.timestamp(), contextSpecificInformation.principalName(), PolarisEvent.ResourceType.TABLE, TableIdentifier.of((Namespace)event.namespace(), (String)event.tableName()).toString());
        Map<String, String> additionalParameters = Map.of("table-uuid", tableMetadata.uuid(), "metadata", TableMetadataParser.toJson((TableMetadata)tableMetadata));
        polarisEvent.setAdditionalProperties(additionalParameters);
        this.processEvent(polarisEvent);
    }

    @Override
    public void onAfterCreateCatalog(CatalogsServiceEvents.AfterCreateCatalogEvent event) {
        ContextSpecificInformation contextSpecificInformation = this.getContextSpecificInformation();
        org.apache.polaris.core.entity.PolarisEvent polarisEvent = new org.apache.polaris.core.entity.PolarisEvent(event.catalog().getName(), PolarisEvent.createEventId(), this.getRequestId(), event.getClass().getSimpleName(), contextSpecificInformation.timestamp(), contextSpecificInformation.principalName(), PolarisEvent.ResourceType.CATALOG, event.catalog().getName());
        this.processEvent(polarisEvent);
    }

    protected abstract ContextSpecificInformation getContextSpecificInformation();

    @Nullable
    protected abstract String getRequestId();

    protected abstract void processEvent(org.apache.polaris.core.entity.PolarisEvent var1);

    public record ContextSpecificInformation(long timestamp, @Nullable String principalName) {
    }
}

