/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.ImmutableLoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.persistence.resolver.Resolver;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.core.rest.PolarisEndpoints;
import org.apache.polaris.core.rest.PolarisResourcePaths;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.catalog.AccessDelegationMode;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.catalog.api.IcebergRestConfigurationApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.iceberg.CatalogHandlerUtils;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalogHandler;
import org.apache.polaris.service.catalog.validation.IcebergPropertiesValidation;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.http.IcebergHttpUtil;
import org.apache.polaris.service.http.IfNoneMatch;
import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.polaris.service.types.NotificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class IcebergCatalogAdapter
implements IcebergRestCatalogApiService,
IcebergRestConfigurationApiService,
CatalogAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergCatalogAdapter.class);
    private static final Set<Endpoint> DEFAULT_ENDPOINTS = ImmutableSet.builder().add((Object)Endpoint.V1_LIST_NAMESPACES).add((Object)Endpoint.V1_LOAD_NAMESPACE).add((Object)Endpoint.V1_NAMESPACE_EXISTS).add((Object)Endpoint.V1_CREATE_NAMESPACE).add((Object)Endpoint.V1_UPDATE_NAMESPACE).add((Object)Endpoint.V1_DELETE_NAMESPACE).add((Object)Endpoint.V1_LIST_TABLES).add((Object)Endpoint.V1_LOAD_TABLE).add((Object)Endpoint.V1_TABLE_EXISTS).add((Object)Endpoint.V1_CREATE_TABLE).add((Object)Endpoint.V1_UPDATE_TABLE).add((Object)Endpoint.V1_DELETE_TABLE).add((Object)Endpoint.V1_RENAME_TABLE).add((Object)Endpoint.V1_REGISTER_TABLE).add((Object)Endpoint.V1_REPORT_METRICS).add((Object)Endpoint.V1_COMMIT_TRANSACTION).build();
    private static final Set<Endpoint> VIEW_ENDPOINTS = ImmutableSet.builder().add((Object)Endpoint.V1_LIST_VIEWS).add((Object)Endpoint.V1_LOAD_VIEW).add((Object)Endpoint.V1_VIEW_EXISTS).add((Object)Endpoint.V1_CREATE_VIEW).add((Object)Endpoint.V1_UPDATE_VIEW).add((Object)Endpoint.V1_DELETE_VIEW).add((Object)Endpoint.V1_RENAME_VIEW).build();
    private static final Set<Endpoint> COMMIT_ENDPOINT = ImmutableSet.builder().add((Object)Endpoint.create((String)"POST", (String)"/v1/{prefix}/transactions/commit")).build();
    private final PolarisDiagnostics diagnostics;
    private final RealmContext realmContext;
    private final CallContext callContext;
    private final RealmConfig realmConfig;
    private final CallContextCatalogFactory catalogFactory;
    private final ResolutionManifestFactory resolutionManifestFactory;
    private final ResolverFactory resolverFactory;
    private final PolarisMetaStoreManager metaStoreManager;
    private final UserSecretsManager userSecretsManager;
    private final PolarisAuthorizer polarisAuthorizer;
    private final CatalogPrefixParser prefixParser;
    private final ReservedProperties reservedProperties;
    private final CatalogHandlerUtils catalogHandlerUtils;
    private final Instance<ExternalCatalogFactory> externalCatalogFactories;
    private final PolarisEventListener polarisEventListener;

    @Inject
    public IcebergCatalogAdapter(PolarisDiagnostics diagnostics, RealmContext realmContext, CallContext callContext, CallContextCatalogFactory catalogFactory, ResolverFactory resolverFactory, ResolutionManifestFactory resolutionManifestFactory, PolarisMetaStoreManager metaStoreManager, UserSecretsManager userSecretsManager, PolarisAuthorizer polarisAuthorizer, CatalogPrefixParser prefixParser, ReservedProperties reservedProperties, CatalogHandlerUtils catalogHandlerUtils, @Any Instance<ExternalCatalogFactory> externalCatalogFactories, PolarisEventListener polarisEventListener) {
        this.diagnostics = diagnostics;
        this.realmContext = realmContext;
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.catalogFactory = catalogFactory;
        this.resolutionManifestFactory = resolutionManifestFactory;
        this.resolverFactory = resolverFactory;
        this.metaStoreManager = metaStoreManager;
        this.userSecretsManager = userSecretsManager;
        this.polarisAuthorizer = polarisAuthorizer;
        this.prefixParser = prefixParser;
        this.reservedProperties = reservedProperties;
        this.catalogHandlerUtils = catalogHandlerUtils;
        this.externalCatalogFactories = externalCatalogFactories;
        this.polarisEventListener = polarisEventListener;
    }

    private Response withCatalog(SecurityContext securityContext, String prefix, Function<IcebergCatalogHandler, Response> action) {
        Response response;
        block9: {
            String catalogName = this.prefixParser.prefixToCatalogName(this.realmContext, prefix);
            IcebergCatalogHandler wrapper = this.newHandlerWrapper(securityContext, catalogName);
            try {
                response = action.apply(wrapper);
                if (wrapper == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (wrapper != null) {
                        try {
                            wrapper.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    LOGGER.debug("RuntimeException while operating on catalog. Propagating to caller.", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("Error while operating on catalog", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            wrapper.close();
        }
        return response;
    }

    @VisibleForTesting
    IcebergCatalogHandler newHandlerWrapper(SecurityContext securityContext, String catalogName) {
        this.validatePrincipal(securityContext);
        return new IcebergCatalogHandler(this.diagnostics, this.callContext, this.resolutionManifestFactory, this.metaStoreManager, this.userSecretsManager, securityContext, this.catalogFactory, catalogName, this.polarisAuthorizer, this.reservedProperties, this.catalogHandlerUtils, this.externalCatalogFactories, this.polarisEventListener);
    }

    public Response createNamespace(String prefix, CreateNamespaceRequest createNamespaceRequest, RealmContext realmContext, SecurityContext securityContext) {
        IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, createNamespaceRequest.properties());
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.createNamespace(createNamespaceRequest)).build());
    }

    public Response listNamespaces(String prefix, String pageToken, Integer pageSize, String parent, RealmContext realmContext, SecurityContext securityContext) {
        Optional<Namespace> namespaceOptional = Optional.ofNullable(parent).map(this::decodeNamespace);
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.listNamespaces(namespaceOptional.orElse(Namespace.of((String[])new String[0])), pageToken, pageSize)).build());
    }

    public Response loadNamespaceMetadata(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.loadNamespaceMetadata(ns)).build());
    }

    private Response.ResponseBuilder tryInsertETagHeader(Response.ResponseBuilder builder, LoadTableResponse response, String namespace, String tableName) {
        if (response.metadataLocation() != null) {
            builder = builder.header("ETag", (Object)IcebergHttpUtil.generateETagForMetadataFileLocation(response.metadataLocation()));
        } else {
            LOGGER.atWarn().addKeyValue("namespace", (Object)namespace).addKeyValue("tableName", (Object)tableName).log("Response has null metadataLocation; omitting etag");
        }
        return builder;
    }

    public Response namespaceExists(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.namespaceExists(ns);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response dropNamespace(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.dropNamespace(ns);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response updateProperties(String prefix, String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest, RealmContext realmContext, SecurityContext securityContext) {
        IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, updateNamespacePropertiesRequest.updates());
        Namespace ns = this.decodeNamespace(namespace);
        UpdateNamespacePropertiesRequest revisedRequest = UpdateNamespacePropertiesRequest.builder().removeAll(this.reservedProperties.removeReservedProperties(updateNamespacePropertiesRequest.removals())).updateAll(this.reservedProperties.removeReservedProperties(updateNamespacePropertiesRequest.updates())).build();
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.updateNamespaceProperties(ns, revisedRequest)).build());
    }

    private EnumSet<AccessDelegationMode> parseAccessDelegationModes(String accessDelegationMode) {
        EnumSet<AccessDelegationMode> delegationModes = AccessDelegationMode.fromProtocolValuesList(accessDelegationMode);
        Preconditions.checkArgument((delegationModes.isEmpty() || delegationModes.contains((Object)AccessDelegationMode.VENDED_CREDENTIALS) ? 1 : 0) != 0, (String)"Unsupported access delegation mode: %s", (Object)accessDelegationMode);
        return delegationModes;
    }

    public Response createTable(String prefix, String namespace, CreateTableRequest createTableRequest, String accessDelegationMode, RealmContext realmContext, SecurityContext securityContext) {
        IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, createTableRequest.properties());
        EnumSet<AccessDelegationMode> delegationModes = this.parseAccessDelegationModes(accessDelegationMode);
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> {
            Optional<String> refreshCredentialsEndpoint = IcebergCatalogAdapter.getRefreshCredentialsEndpoint(delegationModes, prefix, TableIdentifier.of((String[])new String[]{namespace, createTableRequest.name()}));
            if (createTableRequest.stageCreate()) {
                return Response.ok((Object)catalog.createTableStaged(ns, createTableRequest, delegationModes, refreshCredentialsEndpoint)).build();
            }
            LoadTableResponse response = catalog.createTableDirect(ns, createTableRequest, delegationModes, refreshCredentialsEndpoint);
            return this.tryInsertETagHeader(Response.ok((Object)response), response, namespace, createTableRequest.name()).build();
        });
    }

    public Response listTables(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.listTables(ns, pageToken, pageSize)).build());
    }

    public Response loadTable(String prefix, String namespace, String table, String accessDelegationMode, String ifNoneMatchString, String snapshots, RealmContext realmContext, SecurityContext securityContext) {
        EnumSet<AccessDelegationMode> delegationModes = this.parseAccessDelegationModes(accessDelegationMode);
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        IfNoneMatch ifNoneMatch = IfNoneMatch.fromHeader(ifNoneMatchString);
        if (ifNoneMatch.isWildcard()) {
            throw new BadRequestException("If-None-Match may not take the value of '*'", new Object[0]);
        }
        return this.withCatalog(securityContext, prefix, catalog -> {
            Optional<LoadTableResponse> response = catalog.loadTable(tableIdentifier, snapshots, ifNoneMatch, delegationModes, IcebergCatalogAdapter.getRefreshCredentialsEndpoint(delegationModes, prefix, tableIdentifier));
            if (response.isEmpty()) {
                return Response.notModified().build();
            }
            return this.tryInsertETagHeader(Response.ok((Object)response.get()), response.get(), namespace, table).build();
        });
    }

    private static Optional<String> getRefreshCredentialsEndpoint(EnumSet<AccessDelegationMode> delegationModes, String prefix, TableIdentifier tableIdentifier) {
        return delegationModes.contains((Object)AccessDelegationMode.VENDED_CREDENTIALS) ? Optional.of(new PolarisResourcePaths(prefix).credentialsPath(tableIdentifier)) : Optional.empty();
    }

    public Response tableExists(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.tableExists(tableIdentifier);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response dropTable(String prefix, String namespace, String table, Boolean purgeRequested, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        return this.withCatalog(securityContext, prefix, catalog -> {
            if (purgeRequested != null && purgeRequested.booleanValue()) {
                catalog.dropTableWithPurge(tableIdentifier);
            } else {
                catalog.dropTableWithoutPurge(tableIdentifier);
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response registerTable(String prefix, String namespace, RegisterTableRequest registerTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> {
            LoadTableResponse response = catalog.registerTable(ns, registerTableRequest);
            return this.tryInsertETagHeader(Response.ok((Object)response), response, namespace, registerTableRequest.name()).build();
        });
    }

    public Response renameTable(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.renameTable(renameTableRequest);
            return Response.ok((Object)Response.Status.NO_CONTENT).build();
        });
    }

    public Response updateTable(String prefix, String namespace, String table, CommitTableRequest commitTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        commitTableRequest.updates().stream().filter(MetadataUpdate.SetProperties.class::isInstance).map(MetadataUpdate.SetProperties.class::cast).forEach(setProperties -> IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, setProperties.updated()));
        UpdateTableRequest revisedRequest = UpdateTableRequest.create((TableIdentifier)commitTableRequest.identifier(), (List)commitTableRequest.requirements(), commitTableRequest.updates().stream().map(this.reservedProperties::removeReservedProperties).toList());
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        return this.withCatalog(securityContext, prefix, catalog -> {
            if (IcebergCatalogHandler.isCreate(revisedRequest)) {
                return Response.ok((Object)catalog.updateTableForStagedCreate(tableIdentifier, revisedRequest)).build();
            }
            return Response.ok((Object)catalog.updateTable(tableIdentifier, revisedRequest)).build();
        });
    }

    public Response createView(String prefix, String namespace, CreateViewRequest createViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, createViewRequest.properties());
        ImmutableCreateViewRequest revisedRequest = ImmutableCreateViewRequest.copyOf((CreateViewRequest)createViewRequest).withProperties(this.reservedProperties.removeReservedProperties(createViewRequest.properties()));
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, arg_0 -> IcebergCatalogAdapter.lambda$createView$15(ns, (CreateViewRequest)revisedRequest, arg_0));
    }

    public Response listViews(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.listViews(ns, pageToken, pageSize)).build());
    }

    public Response loadCredentials(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        return this.withCatalog(securityContext, prefix, catalog -> {
            LoadTableResponse loadTableResponse = catalog.loadTableWithAccessDelegation(tableIdentifier, "all", Optional.of(new PolarisResourcePaths(prefix).credentialsPath(tableIdentifier)));
            return Response.ok((Object)ImmutableLoadCredentialsResponse.builder().credentials((Iterable)loadTableResponse.credentials()).build()).build();
        });
    }

    public Response loadView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)view));
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.loadView(tableIdentifier)).build());
    }

    public Response viewExists(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)view));
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.viewExists(tableIdentifier);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response dropView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)view));
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.dropView(tableIdentifier);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response renameView(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.renameView(renameTableRequest);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response replaceView(String prefix, String namespace, String view, CommitViewRequest commitViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        UpdateTableRequest revisedRequest = UpdateTableRequest.create((TableIdentifier)commitViewRequest.identifier(), (List)commitViewRequest.requirements(), commitViewRequest.updates().stream().map(this.reservedProperties::removeReservedProperties).toList());
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)view));
        return this.withCatalog(securityContext, prefix, catalog -> Response.ok((Object)catalog.replaceView(tableIdentifier, revisedRequest)).build());
    }

    public Response commitTransaction(String prefix, CommitTransactionRequest commitTransactionRequest, RealmContext realmContext, SecurityContext securityContext) {
        commitTransactionRequest.tableChanges().stream().flatMap(updateTableRequest -> updateTableRequest.updates().stream()).filter(MetadataUpdate.SetProperties.class::isInstance).map(MetadataUpdate.SetProperties.class::cast).forEach(setProperties -> IcebergPropertiesValidation.validateIcebergProperties(this.realmConfig, setProperties.updated()));
        CommitTransactionRequest revisedRequest = new CommitTransactionRequest(commitTransactionRequest.tableChanges().stream().map(r -> UpdateTableRequest.create((TableIdentifier)r.identifier(), (List)r.requirements(), r.updates().stream().map(this.reservedProperties::removeReservedProperties).toList())).toList());
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.commitTransaction(revisedRequest);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response reportMetrics(String prefix, String namespace, String table, ReportMetricsRequest reportMetricsRequest, RealmContext realmContext, SecurityContext securityContext) {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response sendNotification(String prefix, String namespace, String table, NotificationRequest notificationRequest, RealmContext realmContext, SecurityContext securityContext) {
        Namespace ns = this.decodeNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)RESTUtil.decodeString((String)table));
        return this.withCatalog(securityContext, prefix, catalog -> {
            catalog.sendNotification(tableIdentifier, notificationRequest);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    public Response getConfig(String warehouse, RealmContext realmContext, SecurityContext securityContext) {
        PolarisPrincipal authenticatedPrincipal = (PolarisPrincipal)securityContext.getUserPrincipal();
        if (authenticatedPrincipal == null) {
            throw new NotAuthorizedException("Failed to find authenticatedPrincipal in SecurityContext", new Object[0]);
        }
        if (warehouse == null) {
            throw new BadRequestException("Please specify a warehouse", new Object[0]);
        }
        Resolver resolver = this.resolverFactory.createResolver(securityContext, warehouse);
        ResolverStatus resolverStatus = resolver.resolveAll();
        if (!resolverStatus.getStatus().equals((Object)ResolverStatus.StatusEnum.SUCCESS)) {
            throw new NotFoundException("Unable to find warehouse %s", new Object[]{warehouse});
        }
        ResolvedPolarisEntity resolvedReferenceCatalog = resolver.getResolvedReferenceCatalog();
        Map properties = PolarisEntity.of((PolarisBaseEntity)resolvedReferenceCatalog.getEntity()).getPropertiesAsMap();
        String prefix = this.prefixParser.catalogNameToPrefix(realmContext, warehouse);
        return Response.ok((Object)ConfigResponse.builder().withDefaults(properties).withOverrides((Map)ImmutableMap.of((Object)"prefix", (Object)prefix)).withEndpoints((List)ImmutableList.builder().addAll(DEFAULT_ENDPOINTS).addAll(VIEW_ENDPOINTS).addAll(COMMIT_ENDPOINT).addAll((Iterable)PolarisEndpoints.getSupportedGenericTableEndpoints((RealmConfig)this.realmConfig)).addAll((Iterable)PolarisEndpoints.getSupportedPolicyEndpoints((RealmConfig)this.realmConfig)).build()).build()).build();
    }

    private static /* synthetic */ Response lambda$createView$15(Namespace ns, CreateViewRequest revisedRequest, IcebergCatalogHandler catalog) {
        return Response.ok((Object)catalog.createView(ns, revisedRequest)).build();
    }
}

