/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.external.mapping;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.polaris.service.auth.external.mapping.ClaimsLocator;
import org.apache.polaris.service.auth.external.mapping.PrincipalMapper;
import org.apache.polaris.service.auth.external.tenant.OidcTenantConfiguration;
import org.apache.polaris.service.auth.external.tenant.OidcTenantResolvingAugmentor;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
@Identifier(value="default")
class DefaultPrincipalMapper
implements PrincipalMapper {
    private final ClaimsLocator claimsLocator;

    @Inject
    public DefaultPrincipalMapper(ClaimsLocator claimsLocator) {
        this.claimsLocator = claimsLocator;
    }

    @Override
    public OptionalLong mapPrincipalId(SecurityIdentity identity) {
        JsonWebToken jwt = (JsonWebToken)identity.getPrincipal();
        OidcTenantConfiguration.PrincipalMapper principalMapper = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity).principalMapper();
        return principalMapper.idClaimPath().map(claimPath -> this.claimsLocator.locateClaim((String)claimPath, jwt)).map(id -> {
            Long l;
            if (id instanceof Number) {
                Number number = (Number)id;
                l = number.longValue();
            } else {
                l = Long.parseLong(id.toString());
            }
            return l;
        }).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    @Override
    public Optional<String> mapPrincipalName(SecurityIdentity identity) {
        JsonWebToken jwt = (JsonWebToken)identity.getPrincipal();
        OidcTenantConfiguration.PrincipalMapper principalMapper = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity).principalMapper();
        return principalMapper.nameClaimPath().map(claimPath -> this.claimsLocator.locateClaim((String)claimPath, jwt)).map(Object::toString);
    }
}

