/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PolicyAttachmentTarget {
    @NotNull
    private final TypeEnum type;
    private final List<String> path;

    @ApiModelProperty(example="table-like", required=true, value="Policy can be attached to different levels: 1. table-like: Policies specific to individual tables or views. 2. namespace: Policies applies to a namespace. 3. catalog: Policies that applies to a catalog ")
    @JsonProperty(value="type", required=true)
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="[\"NS1\",\"NS2\",\"test_table_1\"]", value="A list representing the hierarchical path to the target, ordered from the namespace level down to the entity.  If the target is catalog, the path should be either empty or not set. ")
    @JsonProperty(value="path")
    public List<String> getPath() {
        return this.path;
    }

    @JsonCreator
    public PolicyAttachmentTarget(@JsonProperty(value="type", required=true) TypeEnum type, @JsonProperty(value="path") List<String> path) {
        this.type = type;
        this.path = Objects.requireNonNullElse(path, new ArrayList());
    }

    public PolicyAttachmentTarget(TypeEnum type) {
        this.type = type;
        this.path = new ArrayList<String>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypeEnum type) {
        return new Builder(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyAttachmentTarget policyAttachmentTarget = (PolicyAttachmentTarget)o;
        return Objects.equals((Object)this.type, (Object)policyAttachmentTarget.type) && Objects.equals(this.path, policyAttachmentTarget.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyAttachmentTarget {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CATALOG("catalog"),
        NAMESPACE("namespace"),
        TABLE_LIKE("table-like");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private TypeEnum type;
        private List<String> path;

        private Builder() {
        }

        private Builder(TypeEnum type) {
            this.type = type;
        }

        public Builder setType(TypeEnum type) {
            this.type = type;
            return this;
        }

        public Builder setPath(List<String> path) {
            this.path = path;
            return this;
        }

        public PolicyAttachmentTarget build() {
            PolicyAttachmentTarget inst = new PolicyAttachmentTarget(this.type, this.path);
            return inst;
        }
    }
}

