/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.internal.sql.SqlKeyword;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.F;

public class SqlParserUtils {
    public static boolean parseIfExists(SqlLexer lex) {
        SqlLexerToken token = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(token, "IF")) {
            lex.shift();
            SqlParserUtils.skipIfMatchesKeyword(lex, "EXISTS");
            return true;
        }
        return false;
    }

    public static boolean parseIfNotExists(SqlLexer lex) {
        SqlLexerToken token = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(token, "IF")) {
            lex.shift();
            SqlParserUtils.skipIfMatchesKeyword(lex, "NOT");
            SqlParserUtils.skipIfMatchesKeyword(lex, "EXISTS");
            return true;
        }
        return false;
    }

    public static boolean skipCommaOrRightParenthesis(SqlLexer lex) {
        if (lex.shift()) {
            switch (lex.tokenType()) {
                case COMMA: {
                    return false;
                }
                case PARENTHESIS_RIGHT: {
                    return true;
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, ",", ")");
    }

    public static int parseInt(SqlLexer lex) {
        int sign = 1;
        if (lex.lookAhead().tokenType() == SqlLexerTokenType.MINUS) {
            sign = -1;
            lex.shift();
        }
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            try {
                long val = (long)sign * Long.parseLong(lex.token());
                if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                    return (int)val;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[integer]");
    }

    public static boolean parseBoolean(SqlLexer lex) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.token()) {
                case "ON": 
                case "1": {
                    return true;
                }
                case "OFF": 
                case "0": {
                    return false;
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "ON", "OFF", "1", "0");
    }

    public static String parseIdentifier(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[identifier]", additionalExpTokens);
    }

    public static String parseUsername(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[username identifier]", additionalExpTokens);
    }

    public static String parseString(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
            return lex.token();
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[string]", additionalExpTokens);
    }

    public static SqlQualifiedName parseQualifiedIdentifier(SqlLexer lex, String ... additionalExpTokens) {
        if (lex.shift() && SqlParserUtils.isValidIdentifier(lex)) {
            SqlQualifiedName res = new SqlQualifiedName();
            String first = lex.token();
            SqlLexerToken nextTok = lex.lookAhead();
            if (nextTok.tokenType() == SqlLexerTokenType.DOT) {
                lex.shift();
                String second = SqlParserUtils.parseIdentifier(lex, new String[0]);
                return res.schemaName(first).name(second);
            }
            return res.name(first);
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, "[qualified identifier]", additionalExpTokens);
    }

    public static boolean isValidIdentifier(SqlLexerToken token) {
        switch (token.tokenType()) {
            case DEFAULT: {
                char c = token.tokenFirstChar();
                return (c >= 'A' && c <= 'Z' || c == '_') && !SqlKeyword.isKeyword(token.token());
            }
            case QUOTED: {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesKeyword(SqlLexerToken token, String expKeyword) {
        return token.tokenType() == SqlLexerTokenType.DEFAULT && expKeyword.equals(token.token());
    }

    public static void skipIfMatchesKeyword(SqlLexer lex, String expKeyword) {
        if (lex.shift() && SqlParserUtils.matchesKeyword(lex, expKeyword)) {
            return;
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, expKeyword);
    }

    public static boolean skipIfMatchesOptionalKeyword(SqlLexer lex, String expKeyword) {
        SqlLexerToken nextTok = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(nextTok, expKeyword)) {
            lex.shift();
            return true;
        }
        return false;
    }

    public static void skipIfMatches(SqlLexer lex, SqlLexerTokenType tokenTyp) {
        if (lex.shift() && F.eq((Object)lex.tokenType(), (Object)tokenTyp)) {
            return;
        }
        throw SqlParserUtils.errorUnexpectedToken(lex, tokenTyp.asString());
    }

    public static SqlParseException error(SqlLexerToken token, String msg) {
        return SqlParserUtils.error0(token, 1001, msg);
    }

    private static SqlParseException error0(SqlLexerToken token, int code, String msg) {
        return new SqlParseException(token.sql(), token.tokenPosition(), code, msg);
    }

    public static SqlParseException errorUnexpectedToken(SqlLexerToken token) {
        return SqlParserUtils.errorUnexpectedToken0(token, new String[0]);
    }

    public static void errorUnsupportedIfMatchesKeyword(SqlLexerToken token, String keyword) {
        if (SqlParserUtils.matchesKeyword(token, keyword)) {
            throw SqlParserUtils.errorUnsupported(token);
        }
    }

    public static void errorUnsupportedIfMatchesKeyword(SqlLexerToken token, String ... keywords) {
        if (F.isEmpty(keywords)) {
            return;
        }
        for (String keyword : keywords) {
            SqlParserUtils.errorUnsupportedIfMatchesKeyword(token, keyword);
        }
    }

    public static SqlParseException errorUnsupported(SqlLexerToken token) {
        return SqlParserUtils.error0(token, 1002, "Unsupported keyword: \"" + token.token() + "\"");
    }

    public static SqlParseException errorUnexpectedToken(SqlLexer lex, String expToken) {
        return SqlParserUtils.errorUnexpectedToken0(lex, expToken);
    }

    public static SqlParseException errorUnexpectedToken(SqlLexerToken token, String firstExpToken, String ... expTokens) {
        if (F.isEmpty(expTokens)) {
            return SqlParserUtils.errorUnexpectedToken0(token, firstExpToken);
        }
        String[] expTokens0 = new String[expTokens.length + 1];
        expTokens0[0] = firstExpToken;
        System.arraycopy(expTokens, 0, expTokens0, 1, expTokens.length);
        throw SqlParserUtils.errorUnexpectedToken0(token, expTokens0);
    }

    private static SqlParseException errorUnexpectedToken0(SqlLexerToken token, String ... expTokens) {
        String token0 = token.token();
        StringBuilder msg = new StringBuilder(token0 == null ? "Unexpected end of command" : "Unexpected token: \"" + token0 + "\"");
        if (!F.isEmpty(expTokens)) {
            msg.append(" (expected: ");
            boolean first = true;
            for (String expToken : expTokens) {
                if (first) {
                    first = false;
                } else {
                    msg.append(", ");
                }
                msg.append("\"" + expToken + "\"");
            }
            msg.append(")");
        }
        throw SqlParserUtils.error(token, msg.toString());
    }

    private SqlParserUtils() {
    }
}

