/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;

public class OdbcResultSet {
    private final QueryCursorImpl<List<?>> cursor;
    private Iterator iter;
    private ClientListenerProtocolVersion ver;
    private Collection<OdbcColumnMeta> meta;

    OdbcResultSet(FieldsQueryCursor<List<?>> cursor, ClientListenerProtocolVersion ver) {
        assert (cursor instanceof QueryCursorImpl);
        this.cursor = (QueryCursorImpl)cursor;
        this.ver = ver;
        if (this.cursor.isQuery()) {
            this.iter = this.cursor.iterator();
            this.meta = OdbcUtils.convertMetadata(this.cursor.fieldsMeta());
        } else {
            this.iter = null;
            this.meta = new ArrayList<OdbcColumnMeta>();
        }
    }

    public boolean hasUnfetchedRows() {
        return this.iter != null && this.iter.hasNext();
    }

    public Collection<OdbcColumnMeta> fieldsMeta() {
        return this.meta;
    }

    public List<Object> fetch(int maxSize) {
        ArrayList<Object> items = new ArrayList<Object>(maxSize);
        if (this.iter == null) {
            return items;
        }
        for (int i = 0; i < maxSize && this.iter.hasNext(); ++i) {
            items.add(this.iter.next());
        }
        return items;
    }
}

