/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.caching;

import com.amazonaws.encryptionsdk.caching.CryptoMaterialsCache;
import com.amazonaws.encryptionsdk.caching.MsClock;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.DecryptionMaterials;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import javax.annotation.concurrent.GuardedBy;

public class LocalCryptoMaterialsCache
implements CryptoMaterialsCache {
    private static final int MAX_TTL_PRUNE = 10;
    MsClock clock = MsClock.WALLCLOCK;
    private final LinkedHashMap<CacheIdentifier, BaseEntry> cacheMap = new LinkedHashMap(16, 0.75f, true);
    private final TreeSet<BaseEntry> expirationQueue = new TreeSet(LocalCryptoMaterialsCache::compareEntries);
    private final int capacity;

    public LocalCryptoMaterialsCache(int capacity) {
        this.capacity = capacity;
    }

    private static int compareEntries(BaseEntry a, BaseEntry b) {
        if (a == b) {
            return 0;
        }
        int result = Long.compare(a.expirationTimestamp_, b.expirationTimestamp_);
        if (result != 0) {
            return result;
        }
        return Utils.compareObjectIdentity(a, b);
    }

    private synchronized void removeEntry(BaseEntry e) {
        this.expirationQueue.remove(e);
        this.cacheMap.remove(e.identifier_, e);
    }

    private synchronized void prune() {
        this.ttlPrune();
        while (this.cacheMap.size() > this.capacity) {
            this.removeEntry(this.cacheMap.values().iterator().next());
        }
    }

    private void ttlPrune() {
        long now = this.clock.timestamp();
        for (int pruneCount = 0; !this.expirationQueue.isEmpty() && this.expirationQueue.first().expirationTimestamp_ < now && pruneCount < 10; ++pruneCount) {
            this.removeEntry(this.expirationQueue.first());
        }
    }

    private synchronized <T extends BaseEntry> T getEntry(Class<T> klass, byte[] identifier) {
        this.ttlPrune();
        BaseEntry e = this.cacheMap.get(new CacheIdentifier(identifier));
        if (e == null) {
            return null;
        }
        if (e.expirationTimestamp_ < this.clock.timestamp()) {
            this.removeEntry(e);
            return null;
        }
        return (T)((BaseEntry)klass.cast(e));
    }

    private synchronized void putEntry(BaseEntry entry) {
        BaseEntry oldEntry = this.cacheMap.put(entry.identifier_, entry);
        if (oldEntry != null) {
            this.expirationQueue.remove(oldEntry);
        }
        this.expirationQueue.add(entry);
        this.prune();
    }

    @Override
    public CryptoMaterialsCache.EncryptCacheEntry getEntryForEncrypt(byte[] cacheId, CryptoMaterialsCache.UsageStats usageIncrement) {
        EncryptCacheEntryInternal entry = this.getEntry(EncryptCacheEntryInternal.class, cacheId);
        if (entry != null) {
            CryptoMaterialsCache.UsageStats stats = entry.addAndGetUsageStats(usageIncrement);
            return new EncryptCacheEntryExposed(stats, entry);
        }
        return null;
    }

    @Override
    public CryptoMaterialsCache.EncryptCacheEntry putEntryForEncrypt(byte[] cacheId, EncryptionMaterials encryptionMaterials, CryptoMaterialsCache.CacheHint hint, CryptoMaterialsCache.UsageStats initialUsage) {
        EncryptCacheEntryInternal entry = new EncryptCacheEntryInternal(new CacheIdentifier(cacheId), Utils.saturatingAdd(this.clock.timestamp(), hint.getMaxAgeMillis()), encryptionMaterials);
        entry.addAndGetUsageStats(initialUsage);
        this.putEntry(entry);
        return new EncryptCacheEntryExposed(initialUsage, entry);
    }

    @Override
    public CryptoMaterialsCache.DecryptCacheEntry getEntryForDecrypt(byte[] cacheId) {
        return this.getEntry(DecryptCacheEntryInternal.class, cacheId);
    }

    @Override
    public void putEntryForDecrypt(byte[] cacheId, DecryptionMaterials decryptionMaterials, CryptoMaterialsCache.CacheHint hint) {
        DecryptCacheEntryInternal entry = new DecryptCacheEntryInternal(new CacheIdentifier(cacheId), Utils.saturatingAdd(this.clock.timestamp(), hint.getMaxAgeMillis()), decryptionMaterials);
        this.putEntry(entry);
    }

    private final class DecryptCacheEntryInternal
    extends BaseEntry
    implements CryptoMaterialsCache.DecryptCacheEntry {
        final DecryptionMaterials result;

        private DecryptCacheEntryInternal(CacheIdentifier identifier, long expiration, DecryptionMaterials result) {
            super(identifier, expiration);
            this.result = result;
        }

        @Override
        public DecryptionMaterials getResult() {
            return this.result;
        }

        @Override
        public void invalidate() {
            LocalCryptoMaterialsCache.this.removeEntry(this);
        }

        @Override
        public long getEntryCreationTime() {
            return this.creationTime;
        }
    }

    private final class EncryptCacheEntryExposed
    implements CryptoMaterialsCache.EncryptCacheEntry {
        private final CryptoMaterialsCache.UsageStats usageStats_;
        private final EncryptCacheEntryInternal internal_;

        private EncryptCacheEntryExposed(CryptoMaterialsCache.UsageStats usageStats, EncryptCacheEntryInternal internal) {
            this.usageStats_ = usageStats;
            this.internal_ = internal;
        }

        @Override
        public CryptoMaterialsCache.UsageStats getUsageStats() {
            return this.usageStats_;
        }

        @Override
        public long getEntryCreationTime() {
            return this.internal_.creationTime;
        }

        @Override
        public EncryptionMaterials getResult() {
            return this.internal_.result;
        }

        @Override
        public void invalidate() {
            LocalCryptoMaterialsCache.this.removeEntry(this.internal_);
        }
    }

    private final class EncryptCacheEntryInternal
    extends BaseEntry {
        private final EncryptionMaterials result;
        @GuardedBy(value="this")
        private CryptoMaterialsCache.UsageStats usageStats;

        private EncryptCacheEntryInternal(CacheIdentifier identifier, long expiration, EncryptionMaterials result) {
            super(identifier, expiration);
            this.usageStats = CryptoMaterialsCache.UsageStats.ZERO;
            this.result = result;
        }

        synchronized CryptoMaterialsCache.UsageStats addAndGetUsageStats(CryptoMaterialsCache.UsageStats delta) {
            this.usageStats = this.usageStats.add(delta);
            return this.usageStats;
        }
    }

    private static final class CacheIdentifier {
        private final byte[] identifier;
        private final int hashCode;

        private CacheIdentifier(byte[] passed_id) {
            this.identifier = (byte[])passed_id.clone();
            this.hashCode = Arrays.hashCode(passed_id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.identifier, ((CacheIdentifier)o).identifier);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class BaseEntry {
        final CacheIdentifier identifier_;
        final long expirationTimestamp_;
        final long creationTime;

        private BaseEntry(CacheIdentifier identifier, long expiration) {
            this.creationTime = LocalCryptoMaterialsCache.this.clock.timestamp();
            this.identifier_ = identifier;
            this.expirationTimestamp_ = expiration;
        }
    }
}

