/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.jetbrains.annotations.Nullable;

public class ColocationGroup
implements Serializable {
    private static final long serialVersionUID = 1370403193139083025L;
    private final LongList sourceIds;
    private final List<String> nodeNames;
    private final Int2ObjectMap<NodeWithConsistencyToken> assignments;
    private final Map<String, List<PartitionWithConsistencyToken>> partitionsPerNode;

    public ColocationGroup(LongList sourceIds, List<String> nodeNames, Int2ObjectMap<NodeWithConsistencyToken> assignments) {
        this.sourceIds = Objects.requireNonNull(sourceIds, "sourceIds");
        this.nodeNames = Objects.requireNonNull(nodeNames, "nodeNames");
        this.assignments = Objects.requireNonNull(assignments, "assignments");
        this.partitionsPerNode = null;
    }

    public ColocationGroup(LongList sourceIds, List<String> nodeNames, Int2ObjectMap<NodeWithConsistencyToken> assignments, Map<String, List<PartitionWithConsistencyToken>> partitionsPerNode) {
        this.sourceIds = Objects.requireNonNull(sourceIds, "sourceIds");
        this.nodeNames = Objects.requireNonNull(nodeNames, "nodeNames");
        this.assignments = Objects.requireNonNull(assignments, "assignments");
        this.partitionsPerNode = Objects.requireNonNull(partitionsPerNode, "partitionsPerNode");
    }

    private ColocationGroup(List<String> nodeNames, LongList sourceIds, Int2ObjectMap<NodeWithConsistencyToken> assignments, @Nullable Map<String, List<PartitionWithConsistencyToken>> partitionsPerNode) {
        this.sourceIds = sourceIds;
        this.nodeNames = nodeNames;
        this.assignments = assignments;
        this.partitionsPerNode = partitionsPerNode;
    }

    public LongList sourceIds() {
        return this.sourceIds;
    }

    public List<String> nodeNames() {
        return this.nodeNames;
    }

    public Int2ObjectMap<NodeWithConsistencyToken> assignments() {
        return this.assignments;
    }

    public List<PartitionWithConsistencyToken> partitionsWithConsistencyTokens(String nodeName) {
        if (this.partitionsPerNode != null) {
            return this.partitionsPerNode.getOrDefault(nodeName, Collections.emptyList());
        }
        return PartitionProvider.partitionsForNode(this.assignments, nodeName);
    }

    public ColocationGroup removeSources(LongSet ids) {
        LongArrayList list = new LongArrayList(this.sourceIds);
        list.removeAll((LongCollection)ids);
        return new ColocationGroup(this.nodeNames, (LongList)list, this.assignments, this.partitionsPerNode);
    }
}

