/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.raft.jraft.JRaftUtils;
import org.apache.ignite.raft.jraft.error.InvokeTimeoutException;
import org.apache.ignite.raft.jraft.error.RemotingException;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.InvokeCallback;
import org.apache.ignite.raft.jraft.rpc.InvokeContext;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RpcClientEx;
import org.apache.ignite.raft.jraft.util.Endpoint;
import org.apache.ignite.raft.jraft.util.Utils;

public class IgniteRpcClient
implements RpcClientEx {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteRpcClient.class);
    private volatile BiPredicate<Object, String> recordPred;
    private BiPredicate<Object, String> blockPred;
    private LinkedBlockingQueue<Object[]> blockedMsgs = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Object[]> recordedMsgs = new LinkedBlockingQueue();
    private final ClusterService service;

    public IgniteRpcClient(ClusterService service) {
        this.service = service;
    }

    public ClusterService clusterService() {
        return this.service;
    }

    @Override
    public boolean checkConnection(Endpoint endpoint) {
        NetworkAddress addr = JRaftUtils.addressFromEndpoint(endpoint);
        return this.service.topologyService().getByAddress(addr) != null;
    }

    @Override
    public void registerConnectEventListener(TopologyEventHandler handler) {
        this.service.topologyService().addEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Message> invokeAsync(Endpoint endpoint, Object request, InvokeContext ctx, InvokeCallback callback, long timeoutMs) {
        CompletableFuture<Message> fut = new CompletableFuture<Message>();
        fut.orTimeout(timeoutMs, TimeUnit.MILLISECONDS).whenComplete((res, err) -> {
            assert (res != null || err != null) : res + " " + err;
            if (err == null && this.recordPred != null && this.recordPred.test(res, this.toString())) {
                this.recordedMsgs.add(new Object[]{res, this.toString(), fut.hashCode(), System.currentTimeMillis(), null});
            }
            if (err instanceof ExecutionException) {
                err = new RemotingException((Throwable)err);
            } else if (err instanceof TimeoutException) {
                err = new InvokeTimeoutException();
            }
            Throwable finalErr = err;
            Utils.runInThread(callback.executor(), () -> callback.complete(res, finalErr));
        });
        if (this.recordPred != null && this.recordPred.test(request, endpoint.toString())) {
            this.recordedMsgs.add(new Object[]{request, endpoint.toString(), fut.hashCode(), System.currentTimeMillis(), null});
        }
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            if (this.blockPred != null && this.blockPred.test(request, endpoint.toString())) {
                Object[] msgData = new Object[]{request, endpoint.toString(), fut.hashCode(), System.currentTimeMillis(), () -> this.send(endpoint, request, fut, timeoutMs)};
                this.blockedMsgs.add(msgData);
                LOG.info("Blocked message to={} id={} msg={}", new Object[]{endpoint.toString(), msgData[2], S.toString((Object)request)});
                return fut;
            }
        }
        this.send(endpoint, request, fut, timeoutMs);
        return fut;
    }

    public void send(Endpoint endpoint, Object request, CompletableFuture<Message> fut, long timeout) {
        CompletableFuture fut0 = this.service.messagingService().invoke(JRaftUtils.addressFromEndpoint(endpoint), (NetworkMessage)request, timeout);
        fut0.whenComplete((resp, err) -> {
            if (err != null) {
                fut.completeExceptionally((Throwable)err);
            } else {
                fut.complete((Message)resp);
            }
        });
    }

    @Override
    public boolean init(RpcOptions opts) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void blockMessages(BiPredicate<Object, String> predicate) {
        this.blockPred = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBlock() {
        ArrayList msgs = new ArrayList();
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            this.blockedMsgs.drainTo(msgs);
            this.blockPred = null;
        }
        for (Object[] msg : msgs) {
            Runnable r = (Runnable)msg[4];
            LOG.info("Unblocked message to={} id={} msg={}", new Object[]{msg[1], msg[2], S.toString((Object)msg[0])});
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBlock(int cnt) {
        ArrayList<Object[]> msgs = new ArrayList<Object[]>();
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            Object[] tmp;
            while (cnt-- > 0 && (tmp = this.blockedMsgs.poll()) != null) {
                msgs.add(tmp);
            }
            this.blockPred = null;
        }
        for (Object[] msg : msgs) {
            Runnable r = (Runnable)msg[4];
            r.run();
        }
    }

    @Override
    public void recordMessages(BiPredicate<Object, String> predicate) {
        this.recordPred = predicate;
    }

    @Override
    public void stopRecord() {
        this.recordPred = null;
    }

    @Override
    public Queue<Object[]> recordedMessages() {
        return this.recordedMsgs;
    }

    @Override
    public Queue<Object[]> blockedMessages() {
        return this.blockedMsgs;
    }
}

