/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.TimeoutNowRequestBuilder;

public class TimeoutNowRequestImpl
implements RpcRequests.TimeoutNowRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3004;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;

    private TimeoutNowRequestImpl(String groupId, String peerId, String serverId, long term) {
        this.groupId = groupId;
        this.peerId = peerId;
        this.serverId = serverId;
        this.term = term;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(TimeoutNowRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3004;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeoutNowRequestImpl otherMessage = (TimeoutNowRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.groupId, this.peerId, this.serverId);
        return result;
    }

    public static TimeoutNowRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TimeoutNowRequestBuilder {
        private String groupId;
        private String peerId;
        private String serverId;
        private long term;

        private Builder() {
        }

        @Override
        public TimeoutNowRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public RpcRequests.TimeoutNowRequest build() {
            return new TimeoutNowRequestImpl(this.groupId, this.peerId, this.serverId, this.term);
        }
    }
}

