/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.GetFileResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.util.ByteString;

public class GetFileResponseImpl
implements RpcRequests.GetFileResponse {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3011;
    @IgniteToStringInclude
    private ByteString data;
    private byte[] dataByteArray;
    @IgniteToStringInclude
    private final boolean eof;
    @IgniteToStringInclude
    private final long readSize;

    private GetFileResponseImpl(ByteString data, byte[] dataByteArray, boolean eof, long readSize) {
        this.data = data;
        this.dataByteArray = dataByteArray;
        this.eof = eof;
        this.readSize = readSize;
    }

    byte[] dataByteArray() {
        return this.dataByteArray;
    }

    @Override
    public ByteString data() {
        return this.data;
    }

    @Override
    public boolean eof() {
        return this.eof;
    }

    @Override
    public long readSize() {
        return this.readSize;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetFileResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3011;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetFileResponseImpl otherMessage = (GetFileResponseImpl)other;
        return Objects.equals(this.data, otherMessage.data) && this.eof == otherMessage.eof && this.readSize == otherMessage.readSize;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.eof, this.readSize, this.data);
        return result;
    }

    public static GetFileResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject dataByteArraymo = marshaller.marshal((Object)this.data);
        usedDescriptors.addAll((IntCollection)dataByteArraymo.usedDescriptorIds());
        this.dataByteArray = dataByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.data = (ByteString)marshaller.unmarshal(this.dataByteArray, descriptorsObj);
        this.dataByteArray = null;
    }

    private static class Builder
    implements GetFileResponseBuilder {
        private ByteString data;
        private byte[] dataByteArray;
        private boolean eof;
        private long readSize;

        private Builder() {
        }

        @Override
        public GetFileResponseBuilder data(ByteString data) {
            this.data = data;
            return this;
        }

        @Override
        public GetFileResponseBuilder dataByteArray(byte[] dataByteArray) {
            this.dataByteArray = dataByteArray;
            return this;
        }

        @Override
        public GetFileResponseBuilder eof(boolean eof) {
            this.eof = eof;
            return this;
        }

        @Override
        public GetFileResponseBuilder readSize(long readSize) {
            this.readSize = readSize;
            return this;
        }

        @Override
        public ByteString data() {
            return this.data;
        }

        @Override
        public byte[] dataByteArray() {
            return this.dataByteArray;
        }

        @Override
        public boolean eof() {
            return this.eof;
        }

        @Override
        public long readSize() {
            return this.readSize;
        }

        @Override
        public RpcRequests.GetFileResponse build() {
            return new GetFileResponseImpl(this.data, this.dataByteArray, this.eof, this.readSize);
        }
    }
}

