/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.ActionRequest;
import org.apache.ignite.raft.jraft.rpc.ActionRequestBuilder;

class ActionRequestDeserializer
implements MessageDeserializer<ActionRequest> {
    private final ActionRequestBuilder msg;

    ActionRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.actionRequest();
    }

    public Class<ActionRequest> klass() {
        return ActionRequest.class;
    }

    public ActionRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.commandByteArray(reader.readByteArray("commandByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.groupId(reader.readString("groupId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.readOnlySafe(reader.readBoolean("readOnlySafe"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ActionRequest.class);
    }
}

