/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.conf;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.PeerId;

public class ConfigurationEntry {
    private static final IgniteLogger LOG = Loggers.forClass(ConfigurationEntry.class);
    private LogId id = new LogId(0L, 0L);
    private Configuration conf = new Configuration();
    private Configuration oldConf = new Configuration();

    public LogId getId() {
        return this.id;
    }

    public void setId(LogId id) {
        this.id = id;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getOldConf() {
        return this.oldConf;
    }

    public void setOldConf(Configuration oldConf) {
        this.oldConf = oldConf;
    }

    public ConfigurationEntry() {
    }

    public ConfigurationEntry(LogId id, Configuration conf, Configuration oldConf) {
        this.id = id;
        this.conf = conf;
        this.oldConf = oldConf;
    }

    public boolean isStable() {
        return this.oldConf.isEmpty();
    }

    public boolean isEmpty() {
        return this.conf.isEmpty();
    }

    public Set<PeerId> listPeers() {
        HashSet<PeerId> ret = new HashSet<PeerId>(this.conf.listPeers());
        ret.addAll(this.oldConf.listPeers());
        return ret;
    }

    public boolean isValid() {
        if (!this.conf.isValid()) {
            return false;
        }
        Set<PeerId> intersection = this.listPeers();
        intersection.retainAll(this.listLearners());
        if (intersection.isEmpty()) {
            return true;
        }
        LOG.error("Invalid conf entry {}, peers and learners have intersection: {}.", new Object[]{this, intersection});
        return false;
    }

    public Set<PeerId> listLearners() {
        HashSet<PeerId> ret = new HashSet<PeerId>(this.conf.getLearners());
        ret.addAll(this.oldConf.getLearners());
        return ret;
    }

    public boolean containsLearner(PeerId learner) {
        return this.conf.getLearners().contains(learner) || this.oldConf.getLearners().contains(learner);
    }

    public boolean contains(PeerId peer) {
        return this.conf.contains(peer) || this.oldConf.contains(peer);
    }

    public String toString() {
        return "ConfigurationEntry [id=" + this.id + ", conf=" + this.conf + ", oldConf=" + this.oldConf + "]";
    }
}

