/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryTableStorage
implements MvTableStorage {
    protected final TableConfiguration tableCfg;
    protected TablesConfiguration tablesConfiguration;
    protected volatile boolean started;
    private volatile AtomicReferenceArray<AbstractPageMemoryMvPartitionStorage> mvPartitions;

    protected AbstractPageMemoryTableStorage(TableConfiguration tableCfg, TablesConfiguration tablesCfg) {
        this.tableCfg = tableCfg;
        this.tablesConfiguration = tablesCfg;
    }

    public TableConfiguration configuration() {
        return this.tableCfg;
    }

    public TablesConfiguration tablesConfiguration() {
        return this.tablesConfiguration;
    }

    public abstract DataRegion<?> dataRegion();

    public void start() throws StorageException {
        TableView tableView = (TableView)this.tableCfg.value();
        this.mvPartitions = new AtomicReferenceArray(tableView.partitions());
        this.started = true;
    }

    public void stop() throws StorageException {
        this.close(false);
    }

    public abstract AbstractPageMemoryMvPartitionStorage createMvPartitionStorage(int var1) throws StorageException;

    public AbstractPageMemoryMvPartitionStorage getOrCreateMvPartition(int partitionId) throws StorageException {
        AbstractPageMemoryMvPartitionStorage partition = this.getMvPartition(partitionId);
        if (partition != null) {
            return partition;
        }
        partition = this.createMvPartitionStorage(partitionId);
        partition.start();
        this.mvPartitions.set(partitionId, partition);
        return partition;
    }

    @Nullable
    public AbstractPageMemoryMvPartitionStorage getMvPartition(int partitionId) {
        assert (this.started) : "Storage has not started yet";
        if (partitionId < 0 || partitionId >= this.mvPartitions.length()) {
            throw new IllegalArgumentException(S.toString((String)"Unable to access partition with id outside of configured range", (String)"table", (Object)((TableView)this.tableCfg.value()).name(), (boolean)false, (String)"partitionId", (Object)partitionId, (boolean)false, (String)"partitions", (Object)this.mvPartitions.length(), (boolean)false));
        }
        return this.mvPartitions.get(partitionId);
    }

    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        assert (this.started) : "Storage has not started yet";
        AbstractPageMemoryMvPartitionStorage partition = this.getMvPartition(partitionId);
        if (partition != null) {
            this.mvPartitions.set(partitionId, null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public SortedIndexStorage getOrCreateSortedIndex(int partitionId, UUID indexId) {
        AbstractPageMemoryMvPartitionStorage partitionStorage = this.getMvPartition(partitionId);
        if (partitionStorage == null) {
            throw new StorageException(String.format("Partition ID %d does not exist", partitionId));
        }
        return partitionStorage.getOrCreateSortedIndex(indexId);
    }

    public HashIndexStorage getOrCreateHashIndex(int partitionId, UUID indexId) {
        AbstractPageMemoryMvPartitionStorage partitionStorage = this.getMvPartition(partitionId);
        if (partitionStorage == null) {
            throw new StorageException(String.format("Partition ID %d does not exist", partitionId));
        }
        return partitionStorage.getOrCreateHashIndex(indexId);
    }

    public CompletableFuture<Void> destroyIndex(UUID indexId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    protected void close(boolean destroy) throws StorageException {
        this.started = false;
        ArrayList<Object> closeables = new ArrayList<Object>();
        for (int i = 0; i < this.mvPartitions.length(); ++i) {
            AbstractPageMemoryMvPartitionStorage partition = this.mvPartitions.getAndUpdate(i, p -> null);
            if (partition == null) continue;
            closeables.add(destroy ? partition::destroy : partition);
        }
        try {
            IgniteUtils.closeAll(closeables);
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop PageMemory table storage.", (Throwable)e);
        }
    }
}

