/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.lang.ByteArray;

class LocalStateStorage {
    private static final ByteArray CMG_STATE_VAULT_KEY = ByteArray.fromString((String)"cmg_state");
    private final VaultManager vault;

    LocalStateStorage(VaultManager vault) {
        this.vault = vault;
    }

    CompletableFuture<LocalState> getLocalState() {
        return this.vault.get(CMG_STATE_VAULT_KEY).thenApply(entry -> entry == null ? null : (LocalState)ByteUtils.fromBytes((byte[])entry.value()));
    }

    CompletableFuture<Void> saveLocalState(LocalState state) {
        return this.vault.put(CMG_STATE_VAULT_KEY, ByteUtils.toBytes((Object)state));
    }

    CompletableFuture<Void> clear() {
        return this.vault.remove(CMG_STATE_VAULT_KEY);
    }

    static class LocalState
    implements Serializable {
        private final Set<String> cmgNodeNames;
        private final ClusterTag clusterTag;

        LocalState(Set<String> cmgNodeNames, ClusterTag clusterTag) {
            this.cmgNodeNames = Set.copyOf(cmgNodeNames);
            this.clusterTag = clusterTag;
        }

        Set<String> cmgNodeNames() {
            return this.cmgNodeNames;
        }

        ClusterTag clusterTag() {
            return this.clusterTag;
        }
    }
}

