/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteAbstractTransactionImpl
implements InternalTransaction {
    private final UUID id;
    protected final TxManager txManager;

    public IgniteAbstractTransactionImpl(TxManager txManager, @NotNull UUID id) {
        this.txManager = txManager;
        this.id = id;
    }

    @Override
    @NotNull
    public UUID id() {
        return this.id;
    }

    @Override
    @Nullable
    public TxState state() {
        return this.txManager.state(this.id);
    }

    public void commit() throws TransactionException {
        try {
            this.commitAsync().get();
        }
        catch (Exception e) {
            throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Transactions.TX_COMMIT_ERR, (Throwable)e);
        }
    }

    public CompletableFuture<Void> commitAsync() {
        return this.finish(true);
    }

    public void rollback() throws TransactionException {
        try {
            this.rollbackAsync().get();
        }
        catch (Exception e) {
            throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Transactions.TX_ROLLBACK_ERR, (Throwable)e);
        }
    }

    public CompletableFuture<Void> rollbackAsync() {
        return this.finish(false);
    }

    protected abstract CompletableFuture<Void> finish(boolean var1);
}

