/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationUtils {
    private ConfigurationNotificationUtils() {
    }

    @Nullable
    static DynamicProperty<Serializable> dynamicProperty(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicProperty)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    static DynamicConfiguration<InnerNode, ?> dynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicConfiguration)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    static NamedListConfiguration<?, InnerNode, ?> namedDynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (NamedListConfiguration)dynamicConfig.members().get(nodeName);
    }

    static <T> Iterator<ConfigurationListener<T>> listeners(@Nullable ConfigurationNode<T> node, long notificationNumber) {
        return node == null ? Collections.emptyIterator() : node.listeners(notificationNumber);
    }

    static <T> Iterator<ConfigurationNamedListListener<T>> extendedListeners(@Nullable NamedListConfiguration<?, T, ?> node, long notificationNumber) {
        return node == null ? Collections.emptyIterator() : node.extendedListeners(notificationNumber);
    }

    @Nullable
    static DynamicConfiguration<InnerNode, ?> any(@Nullable NamedListConfiguration<?, InnerNode, ?> namedConfig) {
        return namedConfig == null ? null : (DynamicConfiguration)namedConfig.any();
    }

    static Collection<DynamicConfiguration<InnerNode, ?>> mergeAnyConfigs(Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, @Nullable DynamicConfiguration<InnerNode, ?> anyConfig) {
        return Stream.concat(anyConfigs.stream(), Stream.of(anyConfig)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

