/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.processor.SingleThreadedBufferingProcessor;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.netty.stream.StreamedHttpMessage;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.multipart.HttpData;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

@Internal
public abstract class AbstractBufferingHttpContentProcessor<T>
extends SingleThreadedBufferingProcessor<ByteBufHolder, T>
implements HttpContentProcessor<T> {
    protected final NettyHttpRequest nettyHttpRequest;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();
    protected final HttpServerConfiguration configuration;
    private final long partMaxSize;

    public AbstractBufferingHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.configuration = configuration;
        this.partMaxSize = configuration.getMultipart().getMaxFileSize();
    }

    public void subscribe(Subscriber<? super T> downstreamSubscriber) {
        super.subscribe(downstreamSubscriber);
        this.subscribeUpstream();
    }

    protected final void doOnNext(ByteBufHolder message) {
        long receivedLength = this.receivedLength.addAndGet(this.resolveLength(message));
        if (this.advertisedLength != -1L && receivedLength > this.advertisedLength || receivedLength > this.requestMaxSize) {
            this.fireExceedsLength(receivedLength, this.advertisedLength == -1L ? this.requestMaxSize : this.advertisedLength);
        } else {
            this.onUpstreamMessage(message);
        }
    }

    protected boolean verifyPartDefinedSize(ByteBufHolder message) {
        boolean validPart;
        long partLength = message instanceof HttpData ? ((HttpData)message).definedLength() : -1L;
        boolean bl = validPart = partLength > this.partMaxSize;
        if (validPart) {
            this.fireExceedsLength(partLength, this.partMaxSize);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireExceedsLength(long receivedLength, long expected) {
        try {
            this.onError((Throwable)new ContentLengthExceededException(expected, receivedLength));
        }
        finally {
            this.upstreamSubscription.cancel();
        }
    }

    private long resolveLength(ByteBufHolder message) {
        if (message instanceof HttpData) {
            return ((HttpData)message).length();
        }
        return message.content().readableBytes();
    }

    private void subscribeUpstream() {
        StreamedHttpMessage message = (StreamedHttpMessage)this.nettyHttpRequest.getNativeRequest();
        message.subscribe((Subscriber)this);
    }
}

