/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.tree.io;

import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.lang.IgniteStringBuilder;

public abstract class BplusMetaIo
extends PageIo {
    private static final int LVLS_OFFSET = 40;
    private static final int REFS_OFFSET = 41;
    private static final int LINK_SIZE = 6;
    private static final int MAX_LEVEL = 32;
    protected static final int COMMON_META_END = 233;

    protected BplusMetaIo(int type, int ver) {
        super(type, ver, (byte)2);
    }

    public void initRoot(long pageAdrr, long rootId) {
        this.assertPageType(pageAdrr);
        this.setLevelsCount(pageAdrr, 1);
        this.setFirstPageId(pageAdrr, 0, rootId);
    }

    public int getLevelsCount(long pageAddr) {
        return PageUtils.getUnsignedByte(pageAddr, 40);
    }

    private void setLevelsCount(long pageAddr, int lvls) {
        assert (lvls >= 0 && lvls <= 32) : lvls;
        PageUtils.putUnsignedByte(pageAddr, 40, lvls);
        assert (this.getLevelsCount(pageAddr) == lvls);
    }

    private int offset(int lvl) {
        return lvl * 6 + 41;
    }

    public long getFirstPageId(long pageAddr, int lvl, int partId) {
        return PartitionlessLinks.readPartitionless(partId, pageAddr, this.offset(lvl));
    }

    private void setFirstPageId(long pageAddr, int lvl, long pageId) {
        assert (lvl >= 0 && lvl < this.getLevelsCount(pageAddr)) : lvl;
        PartitionlessLinks.writePartitionless(pageAddr + (long)this.offset(lvl), pageId);
        assert (this.getFirstPageId(pageAddr, lvl, PageIdUtils.partitionId(pageId)) == pageId);
    }

    public int getRootLevel(long pageAddr) {
        int lvls = this.getLevelsCount(pageAddr);
        assert (lvls > 0) : lvls;
        return lvls - 1;
    }

    public void addRoot(long pageAddr, long rootPageId) {
        this.assertPageType(pageAddr);
        int lvl = this.getLevelsCount(pageAddr);
        this.setLevelsCount(pageAddr, lvl + 1);
        this.setFirstPageId(pageAddr, lvl, rootPageId);
    }

    public void cutRoot(long pageAddr) {
        this.assertPageType(pageAddr);
        int lvl = this.getRootLevel(pageAddr);
        this.setLevelsCount(pageAddr, lvl);
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("BPlusMeta [\n\tlevelsCnt=").app(this.getLevelsCount(addr)).app(",\n\trootLvl=").app(this.getRootLevel(addr)).app("\n]");
    }
}

