/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.datapage;

import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.DataPagePayload;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class DataPageReader {
    private final PageMemory pageMemory;
    private final int groupId;
    private final IoStatisticsHolder statisticsHolder;

    public DataPageReader(PageMemory pageMemory, int groupId, IoStatisticsHolder statisticsHolder) {
        this.pageMemory = pageMemory;
        this.groupId = groupId;
        this.statisticsHolder = statisticsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void traverse(long link, PageMemoryTraversal<T> traversal, @Nullable T argument) throws IgniteInternalCheckedException {
        assert (link != 0L);
        int pageSize = this.pageMemory.realPageSize(this.groupId);
        long currentLink = link;
        do {
            long pageId = PageIdUtils.pageId(currentLink);
            long page = this.pageMemory.acquirePage(this.groupId, pageId, this.statisticsHolder);
            try {
                long pageAddr = this.pageMemory.readLock(this.groupId, pageId, page);
                assert (pageAddr != 0L) : currentLink;
                try {
                    AbstractDataPageIo dataIo = (AbstractDataPageIo)this.pageMemory.ioRegistry().resolve(pageAddr);
                    int itemId = PageIdUtils.itemId(currentLink);
                    DataPagePayload data = dataIo.readPayload(pageAddr, itemId, pageSize);
                    currentLink = traversal.consumePagePayload(currentLink, pageAddr, data, argument);
                }
                finally {
                    this.pageMemory.readUnlock(this.groupId, pageId, page);
                }
            }
            finally {
                this.pageMemory.releasePage(this.groupId, pageId, page);
            }
        } while (currentLink != 0L);
        traversal.finish();
    }
}

