/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.mapping;

import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ColumnMapperImpl
implements ColumnMapper {
    private final int[] mapping;
    private final Column[] cols;

    ColumnMapperImpl(SchemaDescriptor schema) {
        this.mapping = new int[schema.length()];
        this.cols = new Column[schema.length()];
        for (int i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = i;
        }
    }

    @Override
    public ColumnMapperImpl add(@NotNull Column col) {
        this.add0(col.schemaIndex(), -1, col);
        return this;
    }

    @Override
    public ColumnMapperImpl add(int from, int to) {
        this.add0(from, to, null);
        return this;
    }

    void add0(int from, int to, @Nullable Column col) {
        this.mapping[from] = to;
        this.cols[from] = col;
    }

    @Override
    public int map(int idx) {
        return idx < this.mapping.length ? this.mapping[idx] : -1;
    }

    @Override
    public Column mappedColumn(int idx) {
        return idx < this.cols.length ? this.cols[idx] : null;
    }
}

