/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.replicator.message.TimestampAwareBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class TimestampAwareDeserializer
implements MessageDeserializer<TimestampAware> {
    private final TimestampAwareBuilder msg;

    TimestampAwareDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.timestampAware();
    }

    public Class<TimestampAware> klass() {
        return TimestampAware.class;
    }

    public TimestampAware getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.timestampByteArray(reader.readByteArray("timestampByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TimestampAware.class);
    }
}

