/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicaResponseBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReplicaResponseImpl
implements ReplicaResponse {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;

    private ReplicaResponseImpl(Object result, byte[] resultByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(ReplicaResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReplicaResponseImpl otherMessage = (ReplicaResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result);
        return result;
    }

    public static ReplicaResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
    }

    private static class Builder
    implements ReplicaResponseBuilder {
        private Object result;
        private byte[] resultByteArray;

        private Builder() {
        }

        @Override
        public ReplicaResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public ReplicaResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public ReplicaResponse build() {
            return new ReplicaResponseImpl(this.result, this.resultByteArray);
        }
    }
}

