/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.sql.SqlColumnType;
import org.jetbrains.annotations.NotNull;

public class TypeUtils {
    private static final Set<SqlTypeName> CONVERTABLE_TYPES = EnumSet.of(SqlTypeName.DATE, new SqlTypeName[]{SqlTypeName.TIME, SqlTypeName.BINARY, SqlTypeName.VARBINARY, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.INTERVAL_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH});

    public static RelDataType combinedRowType(IgniteTypeFactory typeFactory, RelDataType ... types) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        HashSet<String> names = new HashSet<String>();
        for (RelDataType type : types) {
            for (RelDataTypeField field : type.getFieldList()) {
                int idx = 0;
                Object fieldName = field.getName();
                while (!names.add((String)fieldName)) {
                    fieldName = field.getName() + idx++;
                }
                builder.add((String)fieldName, field.getType());
            }
        }
        return builder.build();
    }

    public static boolean needCast(RelDataTypeFactory factory, RelDataType fromType, RelDataType toType) {
        if (fromType instanceof RelDataTypeFactoryImpl.JavaType && toType.getSqlTypeName() == fromType.getSqlTypeName()) {
            return false;
        }
        if (toType.getSqlTypeName() == SqlTypeName.ANY || fromType.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType((RelDataType)fromType) && SqlTypeUtil.isIntType((RelDataType)toType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)factory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom((RelDataType)toType, (RelDataType)fromType, (boolean)true));
        return true;
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, Class<?> ... fields) {
        List<RelDataType> types = Arrays.stream(fields).map(arg_0 -> ((IgniteTypeFactory)typeFactory).createJavaType(arg_0)).collect(Collectors.toList());
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, RelDataType ... fields) {
        List<RelDataType> types = Arrays.asList(fields);
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    private static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields, String namePreffix) {
        List names = IntStream.range(0, fields.size()).mapToObj(ord -> namePreffix + ord).collect(Collectors.toList());
        return typeFactory.createStructType(fields, names);
    }

    public static <RowT> Function<RowT, RowT> resultTypeConverter(ExecutionContext<RowT> ectx, RelDataType resultType) {
        assert (resultType.isStruct());
        if (TypeUtils.hasConvertableFields(resultType)) {
            RowHandler handler = ectx.rowHandler();
            List types = RelOptUtil.getFieldTypeList((RelDataType)resultType);
            RowHandler.RowFactory factory = handler.factory(ectx.getTypeFactory(), types);
            List<Function> converters = Commons.transform(types, t -> TypeUtils.fieldConverter(ectx, t));
            return r -> {
                Object newRow = factory.create();
                assert (handler.columnCount(newRow) == converters.size());
                assert (handler.columnCount(r) == converters.size());
                for (int i = 0; i < converters.size(); ++i) {
                    handler.set(i, newRow, ((Function)converters.get(i)).apply(handler.get(i, r)));
                }
                return newRow;
            };
        }
        return Function.identity();
    }

    private static Function<Object, Object> fieldConverter(ExecutionContext<?> ectx, RelDataType fieldType) {
        Type storageType = ectx.getTypeFactory().getResultClass(fieldType);
        if (TypeUtils.isConvertableType(fieldType)) {
            return v -> TypeUtils.fromInternal(ectx, v, storageType);
        }
        return Function.identity();
    }

    public static boolean isConvertableType(RelDataType type) {
        return CONVERTABLE_TYPES.contains(type.getSqlTypeName());
    }

    private static boolean hasConvertableFields(RelDataType resultType) {
        return RelOptUtil.getFieldTypeList((RelDataType)resultType).stream().anyMatch(TypeUtils::isConvertableType);
    }

    public static Object toInternal(ExecutionContext<?> ectx, Object val) {
        return val == null ? null : TypeUtils.toInternal(ectx, val, val.getClass());
    }

    public static Object toInternal(ExecutionContext<?> ectx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == LocalDate.class) {
            return (int)((LocalDate)val).toEpochDay();
        }
        if (storageType == LocalTime.class) {
            return (int)TimeUnit.NANOSECONDS.toMillis(((LocalTime)val).toNanoOfDay());
        }
        if (storageType == LocalDateTime.class) {
            LocalDateTime dt = (LocalDateTime)val;
            return TimeUnit.SECONDS.toMillis(dt.toEpochSecond(ZoneOffset.UTC)) + TimeUnit.NANOSECONDS.toMillis(dt.getNano());
        }
        if (storageType == Duration.class) {
            return TimeUnit.SECONDS.toMillis(((Duration)val).getSeconds()) + TimeUnit.NANOSECONDS.toMillis(((Duration)val).getNano());
        }
        if (storageType == Period.class) {
            return (int)((Period)val).toTotalMonths();
        }
        if (storageType == byte[].class) {
            return new ByteString((byte[])val);
        }
        return val;
    }

    public static Object fromInternal(ExecutionContext<?> ectx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == LocalDate.class && val instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)val).intValue());
        }
        if (storageType == LocalTime.class && val instanceof Integer) {
            return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)val).intValue()));
        }
        if (storageType == LocalDateTime.class && val instanceof Long) {
            return LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds((Long)val), (int)TimeUnit.MILLISECONDS.toNanos((Long)val % 1000L), ZoneOffset.UTC);
        }
        if (storageType == Duration.class && val instanceof Long) {
            return Duration.ofMillis((Long)val);
        }
        if (storageType == Period.class && val instanceof Integer) {
            return Period.of((Integer)val / 12, (Integer)val % 12, 0);
        }
        if (storageType == byte[].class && val instanceof ByteString) {
            return ((ByteString)val).getBytes();
        }
        return val;
    }

    public static SqlColumnType columnType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return SqlColumnType.STRING;
            }
            case DATE: {
                return SqlColumnType.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return SqlColumnType.TIME;
            }
            case INTEGER: {
                return SqlColumnType.INT32;
            }
            case TIMESTAMP: {
                return SqlColumnType.DATETIME;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SqlColumnType.TIMESTAMP;
            }
            case BIGINT: {
                return SqlColumnType.INT64;
            }
            case SMALLINT: {
                return SqlColumnType.INT16;
            }
            case TINYINT: {
                return SqlColumnType.INT8;
            }
            case BOOLEAN: {
                return SqlColumnType.BOOLEAN;
            }
            case DECIMAL: {
                return SqlColumnType.DECIMAL;
            }
            case DOUBLE: {
                return SqlColumnType.DOUBLE;
            }
            case REAL: 
            case FLOAT: {
                return SqlColumnType.FLOAT;
            }
            case BINARY: 
            case VARBINARY: 
            case ANY: 
            case OTHER: {
                return SqlColumnType.BYTE_ARRAY;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return SqlColumnType.PERIOD;
            }
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: 
            case INTERVAL_DAY: {
                return SqlColumnType.DURATION;
            }
        }
        assert (false) : "Unexpected type of result: " + type.getSqlTypeName();
        return null;
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType, boolean nullable) {
        return factory.createTypeWithNullability(TypeUtils.native2relationalType(factory, nativeType), nullable);
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType) {
        switch (nativeType.spec()) {
            case INT8: {
                return factory.createSqlType(SqlTypeName.TINYINT);
            }
            case INT16: {
                return factory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT32: {
                return factory.createSqlType(SqlTypeName.INTEGER);
            }
            case INT64: {
                return factory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return factory.createSqlType(SqlTypeName.REAL);
            }
            case DOUBLE: {
                return factory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DECIMAL: {
                assert (nativeType instanceof DecimalNativeType);
                DecimalNativeType decimal = (DecimalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.DECIMAL, decimal.precision(), decimal.scale());
            }
            case UUID: {
                throw new AssertionError((Object)"UUID is not supported yet");
            }
            case STRING: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.VARCHAR, varlen.length());
            }
            case BYTES: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.BINARY, varlen.length());
            }
            case BITMASK: {
                throw new AssertionError((Object)"BITMASK is not supported yet");
            }
            case NUMBER: {
                assert (nativeType instanceof NumberNativeType);
                NumberNativeType number = (NumberNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.DECIMAL, number.precision(), 0);
            }
            case DATE: {
                return factory.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType time = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIME, time.precision());
            }
            case TIMESTAMP: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType ts = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, ts.precision());
            }
            case DATETIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType dt = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP, dt.precision());
            }
        }
        throw new IllegalStateException("Unexpected native type " + nativeType);
    }
}

