/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.util.RexUtils;

public class FilterConverterRule
extends AbstractIgniteConverterRule<LogicalFilter> {
    public static final RelOptRule INSTANCE = new FilterConverterRule();

    public FilterConverterRule() {
        super(LogicalFilter.class, "FilterConverterRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalFilter rel) {
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.getCondition());
        if (!corrIds.isEmpty()) {
            traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds)).replace((RelTrait)RewindabilityTrait.REWINDABLE);
        }
        return new IgniteFilter(cluster, traits, FilterConverterRule.convert((RelNode)rel.getInput(), (RelTraitSet)traits.replace((RelTrait)CorrelationTrait.UNCORRELATED)), rel.getCondition());
    }
}

