/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.agg;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceAggregateBase;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSortAggregateBase;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;

public class IgniteReduceSortAggregate
extends IgniteReduceAggregateBase
implements IgniteSortAggregateBase {
    private final RelCollation collation;

    public IgniteReduceSortAggregate(RelOptCluster cluster, RelTraitSet traits, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, RelDataType rowType, RelCollation collation) {
        super(cluster, traits, input, groupSet, groupSets, aggCalls, rowType);
        assert (Objects.nonNull(collation));
        assert (!collation.isDefault());
        this.collation = collation;
    }

    public IgniteReduceSortAggregate(RelInput input) {
        super(input);
        this.collation = input.getCollation();
        assert (Objects.nonNull(this.collation));
        assert (!this.collation.isDefault());
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteReduceSortAggregate(this.getCluster(), traitSet, (RelNode)IgniteReduceSortAggregate.sole(inputs), this.groupSet, this.groupSets, this.aggCalls, this.rowType, TraitUtils.collation(traitSet));
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteReduceSortAggregate(cluster, this.getTraitSet().replace((RelTrait)this.collation), (RelNode)IgniteReduceSortAggregate.sole(inputs), this.groupSet, this.groupSets, this.aggCalls, this.rowType, this.collation);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("collation", (Object)this.collation);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double rows = mq.getRowCount(this.getInput());
        return costFactory.makeCost(rows, rows * 1.0, 0.0);
    }
}

