/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.table.TupleImpl;
import org.jetbrains.annotations.NotNull;

public interface Tuple
extends Iterable<Object> {
    public static Tuple create() {
        return new TupleImpl();
    }

    public static Tuple create(int capacity) {
        return new TupleImpl(capacity);
    }

    public static Tuple create(Map<String, Object> map) {
        TupleImpl tuple = new TupleImpl(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            tuple.set(entry.getKey(), entry.getValue());
        }
        return tuple;
    }

    public static Tuple create(Tuple tuple) {
        return new TupleImpl(tuple);
    }

    public static int hashCode(Tuple tuple) {
        int hash = 0;
        for (int idx = 0; idx < tuple.columnCount(); ++idx) {
            String columnName = tuple.columnName(idx);
            Object columnValue = tuple.value(idx);
            hash += columnName.hashCode() ^ (columnValue == null ? 0 : columnValue.hashCode());
        }
        return hash;
    }

    public int hashCode();

    public static boolean equals(Tuple firstTuple, Tuple secondTuple) {
        if (firstTuple == secondTuple) {
            return true;
        }
        int columns = firstTuple.columnCount();
        if (columns != secondTuple.columnCount()) {
            return false;
        }
        for (int idx = 0; idx < columns; ++idx) {
            int idx2 = secondTuple.columnIndex(firstTuple.columnName(idx));
            if (idx2 < 0) {
                return false;
            }
            if (Objects.deepEquals(firstTuple.value(idx), secondTuple.value(idx2))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object var1);

    public int columnCount();

    public String columnName(int var1);

    public int columnIndex(@NotNull String var1);

    public <T> T valueOrDefault(@NotNull String var1, T var2);

    public Tuple set(@NotNull String var1, Object var2);

    public <T> T value(@NotNull String var1) throws IllegalArgumentException;

    public <T> T value(int var1);

    public BinaryObject binaryObjectValue(@NotNull String var1);

    public BinaryObject binaryObjectValue(int var1);

    public byte byteValue(@NotNull String var1);

    public byte byteValue(int var1);

    public short shortValue(@NotNull String var1);

    public short shortValue(int var1);

    public int intValue(@NotNull String var1);

    public int intValue(int var1);

    public long longValue(@NotNull String var1);

    public long longValue(int var1);

    public float floatValue(@NotNull String var1);

    public float floatValue(int var1);

    public double doubleValue(@NotNull String var1);

    public double doubleValue(int var1);

    public String stringValue(@NotNull String var1);

    public String stringValue(int var1);

    public UUID uuidValue(@NotNull String var1);

    public UUID uuidValue(int var1);

    public BitSet bitmaskValue(@NotNull String var1);

    public BitSet bitmaskValue(int var1);

    public LocalDate dateValue(String var1);

    public LocalDate dateValue(int var1);

    public LocalTime timeValue(String var1);

    public LocalTime timeValue(int var1);

    public LocalDateTime datetimeValue(String var1);

    public LocalDateTime datetimeValue(int var1);

    public Instant timestampValue(String var1);

    public Instant timestampValue(int var1);
}

