/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.jetbrains.annotations.Nullable;

public class IgniteException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private final String groupName;
    private final int code;
    private final UUID traceId;

    @Deprecated
    public IgniteException() {
        this(ErrorGroups.Common.UNKNOWN_ERR);
    }

    @Deprecated
    public IgniteException(String msg) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg);
    }

    @Deprecated
    public IgniteException(Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, cause);
    }

    @Deprecated
    public IgniteException(String msg, @Nullable Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg, cause);
    }

    public IgniteException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteException(UUID traceId, int code) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, null));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteException(UUID traceId, int code, String message) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, (String)message));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteException(int code, Throwable cause) {
        this(UUID.randomUUID(), code, cause);
    }

    public IgniteException(UUID traceId, int code, Throwable cause) {
        super(ErrorGroup.errorMessageFromCause((UUID)traceId, (int)code, (Throwable)cause), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteException(int code, String message, Throwable cause) {
        this(UUID.randomUUID(), code, message, cause);
    }

    public IgniteException(UUID traceId, int code, String message, Throwable cause) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, (String)message), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return "IGN-" + this.groupName() + "-" + this.errorCode();
    }

    public int groupCode() {
        return ErrorGroup.extractGroupCode((int)this.code);
    }

    public int errorCode() {
        return ErrorGroup.extractErrorCode((int)this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }

    public static IgniteException wrap(Throwable e) {
        Objects.requireNonNull(e);
        e = ExceptionUtils.unwrapCause((Throwable)e);
        if (e instanceof IgniteException) {
            IgniteException iex = (IgniteException)e;
            try {
                Constructor<?> ctor = e.getClass().getDeclaredConstructor(UUID.class, Integer.TYPE, String.class, Throwable.class);
                return (IgniteException)ctor.newInstance(iex.traceId(), iex.code(), e.getMessage(), e);
            }
            catch (Exception ex) {
                throw new RuntimeException("IgniteException-derived class does not have required constructor: " + e.getClass().getName());
            }
        }
        if (e instanceof IgniteCheckedException) {
            IgniteCheckedException iex = (IgniteCheckedException)e;
            return new IgniteException(iex.traceId(), iex.code(), e.getMessage(), e);
        }
        return new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), e);
    }
}

