/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;

public class HashIndexLocker
implements IndexLocker {
    private final UUID indexId;
    private final LockMode modificationMode;
    private final LockManager lockManager;
    private final Function<BinaryRow, BinaryTuple> indexRowResolver;

    public HashIndexLocker(UUID indexId, boolean unique, LockManager lockManager, Function<BinaryRow, BinaryTuple> indexRowResolver) {
        this.indexId = indexId;
        this.modificationMode = unique ? LockMode.X : LockMode.IX;
        this.lockManager = lockManager;
        this.indexRowResolver = indexRowResolver;
    }

    @Override
    public UUID id() {
        return this.indexId;
    }

    @Override
    public CompletableFuture<?> locksForLookup(UUID txId, BinaryRow tableRow) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), LockMode.S);
    }

    @Override
    public CompletableFuture<?> locksForInsert(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), this.modificationMode);
    }

    @Override
    public CompletableFuture<?> locksForRemove(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.apply(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, (Object)key.byteBuffer()), this.modificationMode);
    }
}

