/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.lang.UnexpectedNullValueException;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyValueViewImpl<K, V>
extends AbstractTableView
implements KeyValueView<K, V> {
    private final Function<SchemaDescriptor, KvMarshaller<K, V>> marshallerFactory = schema -> new KvMarshallerImpl(schema, keyMapper, valueMapper);
    private volatile KvMarshaller<K, V> marsh;

    public KeyValueViewImpl(InternalTable tbl, SchemaRegistry schemaReg, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        super(tbl, schemaReg);
    }

    public V get(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.getAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(this::unmarshallValue);
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.getNullableAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r)));
    }

    public V getOrDefault(@Nullable Transaction tx, @NotNull K key, V defaultValue) {
        return this.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @NotNull
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, @NotNull K key, V defaultValue) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> IgniteUtils.nonNullOrElse(this.unmarshalNullableValue((BinaryRow)r), (Object)defaultValue));
    }

    public Map<K, V> getAll(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        return this.sync(this.getAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        Collection<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(keys));
        return this.tbl.getAll(rows, (InternalTransaction)tx).thenApply(this::unmarshalPairs);
    }

    public boolean contains(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
    }

    public void put(@Nullable Transaction tx, @NotNull K key, V val) {
        this.sync(this.putAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.upsert(row, (InternalTransaction)tx);
    }

    public void putAll(@Nullable Transaction tx, @NotNull Map<K, V> pairs) {
        this.sync(this.putAllAsync(tx, pairs));
    }

    @NotNull
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, @NotNull Map<K, V> pairs) {
        List<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(pairs));
        return this.tbl.upsertAll(rows, (InternalTransaction)tx);
    }

    public V getAndPut(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        return this.sync(this.getAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.getAndUpsert(this.marshal(key, val), (InternalTransaction)tx).thenApply(this::unmarshallValue);
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, @NotNull K key, V val) {
        return this.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.getAndUpsert(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r)));
    }

    public boolean putIfAbsent(@Nullable Transaction tx, @NotNull K key, V val) {
        return this.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.insert(row, (InternalTransaction)tx);
    }

    public boolean remove(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull K key, V val) {
        return this.sync(this.removeAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key));
        return this.tbl.delete(row, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.deleteExact(row, (InternalTransaction)tx);
    }

    public Collection<K> removeAll(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        return this.sync(this.removeAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        Collection<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(keys));
        return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(this::unmarshalKeys);
    }

    public V getAndRemove(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.getAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(this::unmarshallValue);
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, @NotNull K key) {
        return this.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, @NotNull K key) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(key));
        return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r)));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull K key, V val) {
        return this.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull K key, V oldVal, V newVal) {
        return this.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.replace(row, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull K key, V oldVal, V newVal) {
        Objects.requireNonNull(key);
        BinaryRowEx oldRow = this.marshal(key, oldVal);
        BinaryRowEx newRow = this.marshal(key, newVal);
        return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
    }

    public V getAndReplace(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        return this.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.getAndReplace(this.marshal(key, val), (InternalTransaction)tx).thenApply(this::unmarshallValue);
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, @NotNull K key, V val) {
        return this.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(key), val);
        return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r)));
    }

    public <R extends Serializable> R invoke(@Nullable Transaction tx, @NotNull K key, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<R> invokeAsync(@Nullable Transaction tx, @NotNull K key, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <R extends Serializable> Map<K, R> invokeAll(@Nullable Transaction tx, @NotNull Collection<K> keys, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<Map<K, R>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private KvMarshaller<K, V> marshaller(int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        this.marsh = this.marshallerFactory.apply(this.schemaReg.schema(schemaVersion));
        return this.marsh;
    }

    private BinaryRowEx marshal(@NotNull K key) {
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        try {
            return marsh.marshal(key);
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private BinaryRowEx marshal(@NotNull K key, V val) {
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        try {
            return marsh.marshal(key, val);
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
    }

    private Collection<BinaryRowEx> marshal(Collection<K> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(keys.size());
        try {
            for (K key : keys) {
                keyRows.add((BinaryRowEx)marsh.marshal(Objects.requireNonNull(key)));
            }
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
        return keyRows;
    }

    private List<BinaryRowEx> marshal(Map<K, V> pairs) {
        if (pairs.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(pairs.size());
        try {
            for (Map.Entry<K, V> pair : pairs.entrySet()) {
                rows.add((BinaryRowEx)marsh.marshal(Objects.requireNonNull(pair.getKey()), pair.getValue()));
            }
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
        return rows;
    }

    private Collection<K> unmarshalKeys(Collection<BinaryRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<Object> keys = new ArrayList<Object>(rows.size());
        try {
            for (Row row : this.schemaReg.resolve(rows)) {
                if (row == null) continue;
                keys.add(marsh.unmarshalKey(row));
            }
            return keys;
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
    }

    @Nullable
    private V unmarshalNullableValue(@Nullable BinaryRow binaryRow) {
        if (binaryRow == null || !binaryRow.hasValue()) {
            return null;
        }
        Row row = this.schemaReg.resolve(binaryRow);
        KvMarshaller<K, V> marshaller = this.marshaller(row.schemaVersion());
        try {
            return (V)marshaller.unmarshalValue(row);
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
    }

    private Map<K, V> unmarshalPairs(Collection<BinaryRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyMap();
        }
        KvMarshaller<K, V> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        HashMap pairs = IgniteUtils.newHashMap((int)rows.size());
        try {
            for (Row row : this.schemaReg.resolve(rows)) {
                pairs.put(marsh.unmarshalKey(row), marsh.unmarshalValue(row));
            }
            return pairs;
        }
        catch (MarshallerException e) {
            throw new org.apache.ignite.lang.MarshallerException((Throwable)e);
        }
    }

    @Nullable
    private V unmarshallValue(@Nullable BinaryRow binaryRow) {
        if (binaryRow == null) {
            return null;
        }
        V v = this.unmarshalNullableValue(binaryRow);
        if (v == null) {
            throw new UnexpectedNullValueException("use `getNullable` sibling method instead.");
        }
        return v;
    }
}

