/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;

public class GridFilenameUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = GridFilenameUtils.isSystemWindows() ? (char)47 : (char)92;

    private GridFilenameUtils() {
    }

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String normalize(String filename) {
        return GridFilenameUtils.doNormalize(filename, SYSTEM_SEPARATOR, true);
    }

    public static String normalize(String filename, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return GridFilenameUtils.doNormalize(filename, separator, true);
    }

    public static String normalizeNoEndSeparator(String filename) {
        return GridFilenameUtils.doNormalize(filename, SYSTEM_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String filename, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return GridFilenameUtils.doNormalize(filename, separator, false);
    }

    private static String doNormalize(String filename, char separator, boolean keepSeparator) {
        int i;
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = GridFilenameUtils.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        char[] arr = new char[size + 2];
        filename.getChars(0, filename.length(), arr, 0);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (arr[i2] != otherSeparator) continue;
            arr[i2] = separator;
        }
        boolean lastIsDir = true;
        if (arr[size - 1] != separator) {
            arr[size++] = separator;
            lastIsDir = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (arr[i] != separator || arr[i - 1] != separator) continue;
            System.arraycopy(arr, i, arr, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (arr[i] != separator || arr[i - 1] != '.' || i != prefix + 1 && arr[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDir = true;
            }
            System.arraycopy(arr, i + 1, arr, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (arr[i] != separator || arr[i - 1] != '.' || arr[i - 2] != '.' || i != prefix + 2 && arr[i - 3] != separator) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDir = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (arr[j] != separator) continue;
                System.arraycopy(arr, i + 1, arr, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(arr, i + 1, arr, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(arr, 0, size);
        }
        if (lastIsDir && keepSeparator) {
            return new String(arr, 0, size);
        }
        return new String(arr, 0, size - 1);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        int prefix = GridFilenameUtils.getPrefixLength(fullFilenameToAdd);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return GridFilenameUtils.normalize(fullFilenameToAdd);
        }
        if (basePath == null) {
            return null;
        }
        int len = basePath.length();
        if (len == 0) {
            return GridFilenameUtils.normalize(fullFilenameToAdd);
        }
        char ch = basePath.charAt(len - 1);
        if (GridFilenameUtils.isSeparator(ch)) {
            return GridFilenameUtils.normalize(basePath + fullFilenameToAdd);
        }
        return GridFilenameUtils.normalize(basePath + "/" + fullFilenameToAdd);
    }

    public static boolean directoryContains(String canonicalParent, String canonicalChild) throws IOException {
        if (canonicalParent == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (canonicalChild == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(canonicalParent, canonicalChild)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(canonicalChild, canonicalParent);
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static String separatorsToWindows(String path) {
        if (path == null || path.indexOf(47) == -1) {
            return path;
        }
        return path.replace('/', '\\');
    }

    public static String separatorsToSystem(String path) {
        if (path == null) {
            return null;
        }
        if (GridFilenameUtils.isSystemWindows()) {
            return GridFilenameUtils.separatorsToWindows(path);
        }
        return GridFilenameUtils.separatorsToUnix(path);
    }

    public static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return GridFilenameUtils.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !GridFilenameUtils.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (GridFilenameUtils.isSeparator(ch0) && GridFilenameUtils.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return GridFilenameUtils.isSeparator(ch0) ? 1 : 0;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = GridFilenameUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getPrefix(String filename) {
        if (filename == null) {
            return null;
        }
        int len = GridFilenameUtils.getPrefixLength(filename);
        if (len < 0) {
            return null;
        }
        if (len > filename.length()) {
            return filename + "/";
        }
        return filename.substring(0, len);
    }

    public static String getPath(String filename) {
        return GridFilenameUtils.doGetPath(filename, 1);
    }

    public static String getPathNoEndSeparator(String filename) {
        return GridFilenameUtils.doGetPath(filename, 0);
    }

    private static String doGetPath(String filename, int separatorAdd) {
        if (filename == null) {
            return null;
        }
        int prefix = GridFilenameUtils.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        int idx = GridFilenameUtils.indexOfLastSeparator(filename);
        int endIdx = idx + separatorAdd;
        if (prefix >= filename.length() || idx < 0 || prefix >= endIdx) {
            return "";
        }
        return filename.substring(prefix, endIdx);
    }

    public static String getFullPath(String filename) {
        return GridFilenameUtils.doGetFullPath(filename, true);
    }

    public static String getFullPathNoEndSeparator(String filename) {
        return GridFilenameUtils.doGetFullPath(filename, false);
    }

    private static String doGetFullPath(String filename, boolean includeSeparator) {
        if (filename == null) {
            return null;
        }
        int prefix = GridFilenameUtils.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= filename.length()) {
            if (includeSeparator) {
                return GridFilenameUtils.getPrefix(filename);
            }
            return filename;
        }
        int idx = GridFilenameUtils.indexOfLastSeparator(filename);
        if (idx < 0) {
            return filename.substring(0, prefix);
        }
        int end = idx + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        return filename.substring(0, end);
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int idx = GridFilenameUtils.indexOfLastSeparator(filename);
        return filename.substring(idx + 1);
    }

    public static String getBaseName(String filename) {
        return GridFilenameUtils.removeExtension(GridFilenameUtils.getName(filename));
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int idx = GridFilenameUtils.indexOfExtension(filename);
        if (idx == -1) {
            return "";
        }
        return filename.substring(idx + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int idx = GridFilenameUtils.indexOfExtension(filename);
        if (idx == -1) {
            return filename;
        }
        return filename.substring(0, idx);
    }

    public static boolean equals(String filename1, String filename2) {
        return GridFilenameUtils.equals(filename1, filename2, false, IOCase.SENSITIVE);
    }

    public static boolean equalsOnSystem(String filename1, String filename2) {
        return GridFilenameUtils.equals(filename1, filename2, false, IOCase.SYSTEM);
    }

    public static boolean equalsNormalized(String filename1, String filename2) {
        return GridFilenameUtils.equals(filename1, filename2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String filename1, String filename2) {
        return GridFilenameUtils.equals(filename1, filename2, true, IOCase.SYSTEM);
    }

    public static boolean equals(String filename1, String filename2, boolean normalized, IOCase caseSensitivity) {
        if (filename1 == null || filename2 == null) {
            return filename1 == null && filename2 == null;
        }
        if (normalized) {
            filename1 = GridFilenameUtils.normalize(filename1);
            filename2 = GridFilenameUtils.normalize(filename2);
            if (filename1 == null || filename2 == null) {
                throw new NullPointerException("Error normalizing one or both of the file names");
            }
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        return caseSensitivity.checkEquals(filename1, filename2);
    }

    public static boolean isExtension(String filename, String extension) {
        if (filename == null) {
            return false;
        }
        if (extension == null || extension.isEmpty()) {
            return GridFilenameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = GridFilenameUtils.getExtension(filename);
        return fileExt.equals(extension);
    }

    public static boolean isExtension(String filename, String[] extensions) {
        if (filename == null) {
            return false;
        }
        if (extensions == null || extensions.length == 0) {
            return GridFilenameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = GridFilenameUtils.getExtension(filename);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtension(String filename, Collection<String> extensions) {
        if (filename == null) {
            return false;
        }
        if (extensions == null || extensions.isEmpty()) {
            return GridFilenameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = GridFilenameUtils.getExtension(filename);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardMatch(String filename, String wildcardMatcher) {
        return GridFilenameUtils.wildcardMatch(filename, wildcardMatcher, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatchOnSystem(String filename, String wildcardMatcher) {
        return GridFilenameUtils.wildcardMatch(filename, wildcardMatcher, IOCase.SYSTEM);
    }

    public static boolean wildcardMatch(String filename, String wildcardMatcher, IOCase caseSensitivity) {
        if (filename == null && wildcardMatcher == null) {
            return true;
        }
        if (filename == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        String[] wcs = GridFilenameUtils.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (!backtrack.isEmpty()) {
                int[] arr = (int[])backtrack.pop();
                wcsIdx = arr[0];
                textIdx = arr[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > filename.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = filename.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(filename, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(filename, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(filename, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != filename.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] arr = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '?' || arr[i] == '*') {
                if (buf.length() != 0) {
                    list.add(buf.toString());
                    buf.setLength(0);
                }
                if (arr[i] == '?') {
                    list.add("?");
                    continue;
                }
                if (!list.isEmpty() && (i <= 0 || ((String)list.get(list.size() - 1)).equals("*"))) continue;
                list.add("*");
                continue;
            }
            buf.append(arr[i]);
        }
        if (buf.length() != 0) {
            list.add(buf.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    static class IOCase
    implements Serializable {
        public static final IOCase SENSITIVE = new IOCase("Sensitive", true);
        public static final IOCase INSENSITIVE = new IOCase("Insensitive", false);
        public static final IOCase SYSTEM = new IOCase("System", !GridFilenameUtils.isSystemWindows());
        private static final long serialVersionUID = -6343169151696340687L;
        private final String name;
        private final transient boolean sensitive;

        public static IOCase forName(String name) {
            if (IOCase.SENSITIVE.name.equals(name)) {
                return SENSITIVE;
            }
            if (IOCase.INSENSITIVE.name.equals(name)) {
                return INSENSITIVE;
            }
            if (IOCase.SYSTEM.name.equals(name)) {
                return SYSTEM;
            }
            throw new IllegalArgumentException("Invalid IOCase name: " + name);
        }

        private IOCase(String name, boolean sensitive) {
            this.name = name;
            this.sensitive = sensitive;
        }

        private Object readResolve() {
            return IOCase.forName(this.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean isCaseSensitive() {
            return this.sensitive;
        }

        public int checkCompareTo(String str1, String str2) {
            if (str1 == null || str2 == null) {
                throw new NullPointerException("The strings must not be null");
            }
            return this.sensitive ? str1.compareTo(str2) : str1.compareToIgnoreCase(str2);
        }

        public boolean checkEquals(String str1, String str2) {
            if (str1 == null || str2 == null) {
                throw new NullPointerException("The strings must not be null");
            }
            return this.sensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
        }

        public boolean checkStartsWith(String str, String start) {
            return str.regionMatches(!this.sensitive, 0, start, 0, start.length());
        }

        public boolean checkEndsWith(String str, String end) {
            int endLen = end.length();
            return str.regionMatches(!this.sensitive, str.length() - endLen, end, 0, endLen);
        }

        public int checkIndexOf(String str, int strStartIndex, String search) {
            int endIdx = str.length() - search.length();
            if (endIdx >= strStartIndex) {
                for (int i = strStartIndex; i <= endIdx; ++i) {
                    if (!this.checkRegionMatches(str, i, search)) continue;
                    return i;
                }
            }
            return -1;
        }

        public boolean checkRegionMatches(String str, int strStartIndex, String search) {
            return str.regionMatches(!this.sensitive, strStartIndex, search, 0, search.length());
        }

        public String toString() {
            return this.name;
        }
    }
}

