/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentation;
import org.apache.ignite.mxbean.DefragmentationMXBean;

public class DefragmentationMXBeanImpl
implements DefragmentationMXBean {
    private final IgniteDefragmentation defragmentation;

    public DefragmentationMXBeanImpl(GridKernalContext ctx) {
        this.defragmentation = ctx.defragmentation();
    }

    @Override
    public boolean schedule(String cacheNames) {
        List<String> caches = Arrays.stream(cacheNames.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        try {
            this.defragmentation.schedule(caches);
            return true;
        }
        catch (IgniteCheckedException e) {
            return false;
        }
    }

    @Override
    public boolean cancel() {
        try {
            this.defragmentation.cancel();
            return true;
        }
        catch (IgniteCheckedException e) {
            return false;
        }
    }

    @Override
    public boolean inProgress() {
        return this.defragmentation.inProgress();
    }

    @Override
    public int processedPartitions() {
        return this.defragmentation.processedPartitions();
    }

    @Override
    public int totalPartitions() {
        return this.defragmentation.totalPartitions();
    }

    @Override
    public long startTime() {
        return this.defragmentation.startTime();
    }
}

