/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheCompoundIdentityFuture<T>
extends GridCompoundIdentityFuture<T>
implements GridCacheFuture<T> {
    private final long startTime = U.currentTimeMillis();
    private volatile long endTime;

    protected GridCacheCompoundIdentityFuture(@Nullable IgniteReducer<T, T> rdc) {
        super(rdc);
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long duration() {
        long endTime = this.endTime;
        return (endTime == 0L ? U.currentTimeMillis() : endTime) - this.startTime;
    }

    @Override
    protected boolean onDone(@Nullable T res, @Nullable Throwable err, boolean cancel) {
        if (super.onDone(res, err, cancel)) {
            this.endTime = U.currentTimeMillis();
            return true;
        }
        return false;
    }
}

