/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class CacheRebalanceConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private CacheRebalanceMode mode;
    private int batchSize;
    private long partitionedDelay;
    private long throttle;
    private long timeout;
    private long batchesPrefetchCnt;
    private int rebalanceOrder;

    public CacheRebalanceConfiguration() {
    }

    public CacheRebalanceConfiguration(CacheConfiguration ccfg) {
        this.mode = ccfg.getRebalanceMode();
        this.batchSize = ccfg.getRebalanceBatchSize();
        this.partitionedDelay = ccfg.getRebalanceDelay();
        this.throttle = ccfg.getRebalanceThrottle();
        this.timeout = ccfg.getRebalanceTimeout();
        this.batchesPrefetchCnt = ccfg.getRebalanceBatchesPrefetchCount();
        this.rebalanceOrder = ccfg.getRebalanceOrder();
    }

    public CacheRebalanceMode getMode() {
        return this.mode;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getPartitionedDelay() {
        return this.partitionedDelay;
    }

    public long getThrottle() {
        return this.throttle;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getBatchesPrefetchCnt() {
        return this.batchesPrefetchCnt;
    }

    public int getRebalanceOrder() {
        return this.rebalanceOrder;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.mode);
        out.writeInt(this.batchSize);
        out.writeLong(this.partitionedDelay);
        out.writeLong(this.throttle);
        out.writeLong(this.timeout);
        out.writeLong(this.batchesPrefetchCnt);
        out.writeInt(this.rebalanceOrder);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.mode = CacheRebalanceMode.fromOrdinal(in.readByte());
        this.batchSize = in.readInt();
        this.partitionedDelay = in.readLong();
        this.throttle = in.readLong();
        this.timeout = in.readLong();
        this.batchesPrefetchCnt = in.readLong();
        this.rebalanceOrder = in.readInt();
    }

    public String toString() {
        return S.toString(CacheRebalanceConfiguration.class, this);
    }
}

