/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.ignite.IgniteLogger;

final class GridUriDeploymentJarVerifier {
    private static final int BUF_SIZE = 4096;

    private GridUriDeploymentJarVerifier() {
    }

    static boolean verify(String jarName, boolean allSigned, IgniteLogger log) throws IOException {
        assert (jarName != null);
        return GridUriDeploymentJarVerifier.verify0(jarName, null, allSigned, log);
    }

    static boolean verify(String jarName, PublicKey pubKey, boolean allSigned, IgniteLogger log) throws IOException {
        assert (jarName != null);
        assert (pubKey != null);
        return GridUriDeploymentJarVerifier.verify0(jarName, pubKey, allSigned, log);
    }

    static boolean verify(InputStream in, boolean allSigned, IgniteLogger log) throws IOException {
        assert (in != null);
        return GridUriDeploymentJarVerifier.verify0(in, null, allSigned, log);
    }

    static boolean verify(InputStream in, PublicKey pubKey, boolean allSigned, IgniteLogger log) throws IOException {
        assert (in != null);
        assert (pubKey != null);
        return GridUriDeploymentJarVerifier.verify0(in, pubKey, allSigned, log);
    }

    /*
     * Exception decompiling
     */
    private static boolean verify0(InputStream in, PublicKey pubKey, boolean allSigned, IgniteLogger log) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static boolean verify0(String jarName, PublicKey pubKey, boolean allSigned, IgniteLogger log) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean verifyEntry(JarEntry jarEntry, Manifest manifest, PublicKey pubKey, boolean allSigned, boolean makeCerts) {
        assert (jarEntry != null);
        assert (manifest != null);
        boolean inManifest = false;
        String entryName = jarEntry.getName();
        if (manifest.getAttributes(entryName) != null || manifest.getAttributes("./" + entryName) != null || manifest.getAttributes("/" + entryName) != null) {
            inManifest = true;
        }
        if (allSigned && !inManifest && !entryName.toUpperCase().startsWith("META-INF/")) {
            return false;
        }
        if (inManifest) {
            boolean isSigned;
            Certificate[] certs = !makeCerts ? jarEntry.getCertificates() : GridUriDeploymentJarVerifier.getCertificates(jarEntry);
            boolean bl = isSigned = certs != null && certs.length > 0;
            if (!isSigned || pubKey != null && !GridUriDeploymentJarVerifier.findKeyInCertificates(pubKey, certs)) {
                return false;
            }
        }
        return true;
    }

    private static void verifyDigestsImplicitly(InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        while (in.read(buf, 0, buf.length) != -1) {
        }
    }

    private static boolean findKeyInCertificates(PublicKey key, Certificate[] certs) {
        if (key == null || certs == null) {
            return false;
        }
        for (Certificate cert : certs) {
            if (!cert.getPublicKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getSignedFiles(Manifest manifest) {
        HashSet<String> fileNames = new HashSet<String>();
        Map<String, Attributes> entries = manifest.getEntries();
        if (entries != null && entries.size() > 0) {
            block0: for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                Attributes attrs = entry.getValue();
                for (Map.Entry<Object, Object> attrEntry : attrs.entrySet()) {
                    if (!attrEntry.getKey().toString().toUpperCase().endsWith("-DIGEST")) continue;
                    fileNames.add(entry.getKey());
                    continue block0;
                }
            }
        }
        return fileNames;
    }

    private static Certificate[] getCertificates(JarEntry entry) {
        Certificate[] certs = null;
        CodeSigner[] signers = entry.getCodeSigners();
        if (signers != null) {
            ArrayList<? extends Certificate> certChains = new ArrayList<Certificate>();
            for (CodeSigner signer : signers) {
                certChains.addAll(signer.getSignerCertPath().getCertificates());
            }
            return certChains.toArray(new Certificate[certChains.size()]);
        }
        return certs;
    }
}

