/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.jdk.JdkMarshallerDummySerializable;

class JdkMarshallerObjectInputStream
extends ObjectInputStream {
    private final ClassLoader clsLdr;
    private final IgnitePredicate<String> clsFilter;

    JdkMarshallerObjectInputStream(InputStream in, ClassLoader clsLdr, IgnitePredicate<String> clsFilter) throws IOException {
        super(in);
        assert (clsLdr != null);
        this.clsLdr = clsLdr;
        this.clsFilter = clsFilter;
        this.enableResolveObject(true);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return U.forName(desc.getName(), this.clsLdr, this.clsFilter);
    }

    @Override
    protected Object resolveObject(Object o) throws IOException {
        if (o != null && o.getClass().equals(JdkMarshallerDummySerializable.class)) {
            return new Object();
        }
        return super.resolveObject(o);
    }
}

