/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistoryResult;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.EarliestCheckpointMapSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.ReservationReason;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.lang.IgniteThrowableBiPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class CheckpointHistory {
    public static final int DFLT_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE = 100;
    private final IgniteLogger log;
    private final NavigableMap<Long, CheckpointEntry> histMap = new ConcurrentSkipListMap<Long, CheckpointEntry>();
    private final int maxCpHistMemSize;
    private final boolean isWalTruncationEnabled;
    private final Map<GroupPartitionId, CheckpointEntry> earliestCp = new ConcurrentHashMap<GroupPartitionId, CheckpointEntry>();
    private final IgniteWriteAheadLogManager wal;
    private final IgniteThrowableBiPredicate<Long, Integer> checkpointInapplicable;
    private final boolean reservationDisabled;

    CheckpointHistory(DataStorageConfiguration dsCfg, Function<Class<?>, IgniteLogger> logFun, IgniteWriteAheadLogManager wal, IgniteThrowableBiPredicate<Long, Integer> inapplicable) {
        this.log = logFun.apply(this.getClass());
        this.wal = wal;
        this.checkpointInapplicable = inapplicable;
        this.isWalTruncationEnabled = dsCfg.getMaxWalArchiveSize() != -1L;
        this.maxCpHistMemSize = IgniteSystemProperties.getInteger("IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", 100);
        this.reservationDisabled = dsCfg.getWalMode() == WALMode.NONE;
    }

    public void initialize(List<CheckpointEntry> checkpoints, EarliestCheckpointMapSnapshot snapshot) {
        for (CheckpointEntry e : checkpoints) {
            this.histMap.put(e.timestamp(), e);
        }
        for (Long timestamp : this.checkpoints(false)) {
            try {
                CheckpointEntry entry = this.entry(timestamp);
                UUID checkpointId = entry.checkpointId();
                Map<Integer, CheckpointEntry.GroupState> grpStateMap = snapshot.groupState(checkpointId);
                if (snapshot.checkpointWasPresent(checkpointId) && grpStateMap == null) continue;
                if (grpStateMap != null) {
                    entry.fillStore(grpStateMap);
                }
                this.updateEarliestCpMap(entry, grpStateMap);
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Failed to process checkpoint, happened at " + U.format(timestamp) + ".", e);
            }
        }
    }

    private CheckpointEntry entry(Long cpTs) throws IgniteCheckedException {
        CheckpointEntry entry = (CheckpointEntry)this.histMap.get(cpTs);
        if (entry == null) {
            throw new IgniteCheckedException("Checkpoint entry was removed: " + cpTs);
        }
        return entry;
    }

    private CheckpointEntry firstCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.firstEntry();
        return entry != null ? entry.getValue() : null;
    }

    @Nullable
    public CheckpointEntry lastCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.lastEntry();
        return entry != null ? entry.getValue() : null;
    }

    public WALPointer firstCheckpointPointer() {
        CheckpointEntry entry = this.firstCheckpoint();
        return entry != null ? entry.checkpointMark() : null;
    }

    public Collection<Long> checkpoints(boolean descending) {
        if (descending) {
            return this.histMap.descendingKeySet();
        }
        return this.histMap.keySet();
    }

    public Collection<Long> checkpoints() {
        return this.checkpoints(false);
    }

    public void addCheckpoint(CheckpointEntry entry, Map<Integer, CacheState> cacheStates) {
        this.addCpCacheStatesToEarliestCpMap(entry, cacheStates);
        this.histMap.put(entry.timestamp(), entry);
    }

    private void updateEarliestCpMap(CheckpointEntry entry, @Nullable Map<Integer, CheckpointEntry.GroupState> groupStateMapFromSnapshot) {
        try {
            Map<Integer, CheckpointEntry.GroupState> states = groupStateMapFromSnapshot != null ? groupStateMapFromSnapshot : entry.groupState(this.wal);
            Iterator<Map.Entry<GroupPartitionId, CheckpointEntry>> iter = this.earliestCp.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<GroupPartitionId, CheckpointEntry> grpPartCp = iter.next();
                int grpId = grpPartCp.getKey().getGroupId();
                if (!this.isCheckpointApplicableForGroup(grpId, entry)) {
                    iter.remove();
                    continue;
                }
                int part = grpPartCp.getKey().getPartitionId();
                int pIdx = states.get(grpId).indexByPartition(part);
                if (pIdx >= 0) continue;
                iter.remove();
            }
            this.addCpGroupStatesToEarliestCpMap(entry, states);
        }
        catch (IgniteCheckedException ex) {
            U.warn(this.log, "Failed to process checkpoint: " + entry, ex);
            this.earliestCp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointEntry removeFromEarliestCheckpoints(Integer grpId) {
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry lastCp = this.lastCheckpoint();
            this.earliestCp.keySet().removeIf(grpPart -> grpId.equals(grpPart.getGroupId()));
            return lastCp;
        }
    }

    private void addCpCacheStatesToEarliestCpMap(CheckpointEntry entry, Map<Integer, CacheState> cacheStates) {
        for (Integer grpId : cacheStates.keySet()) {
            CacheState cacheState = cacheStates.get(grpId);
            for (int pIdx = 0; pIdx < cacheState.size(); ++pIdx) {
                int part = cacheState.partitionByIndex(pIdx);
                GroupPartitionId grpPartKey = new GroupPartitionId(grpId, part);
                this.addPartitionToEarliestCheckpoints(grpPartKey, entry);
            }
        }
    }

    private void addCpGroupStatesToEarliestCpMap(CheckpointEntry entry, Map<Integer, CheckpointEntry.GroupState> cacheGrpStates) {
        for (Integer grpId : cacheGrpStates.keySet()) {
            CheckpointEntry.GroupState grpState = cacheGrpStates.get(grpId);
            for (int pIdx = 0; pIdx < grpState.size(); ++pIdx) {
                int part = grpState.getPartitionByIndex(pIdx);
                GroupPartitionId grpPartKey = new GroupPartitionId(grpId, part);
                this.addPartitionToEarliestCheckpoints(grpPartKey, entry);
            }
        }
    }

    private void addPartitionToEarliestCheckpoints(GroupPartitionId grpPartKey, CheckpointEntry entry) {
        if (!this.earliestCp.containsKey(grpPartKey)) {
            this.earliestCp.put(grpPartKey, entry);
        }
    }

    public boolean hasSpace() {
        return this.isWalTruncationEnabled || this.histMap.size() + 1 <= this.maxCpHistMemSize;
    }

    public List<CheckpointEntry> onWalTruncated(WALPointer highBound) {
        CheckpointEntry cpEntry;
        WALPointer cpPnt;
        ArrayList<CheckpointEntry> removed = new ArrayList<CheckpointEntry>();
        Iterator iterator = this.histMap.values().iterator();
        while (iterator.hasNext() && highBound.compareTo(cpPnt = (cpEntry = (CheckpointEntry)iterator.next()).checkpointMark()) > 0 && this.removeCheckpoint(cpEntry)) {
            removed.add(cpEntry);
        }
        return removed;
    }

    public List<CheckpointEntry> removeCheckpoints(int countToRemove) {
        Map.Entry entry;
        CheckpointEntry checkpoint;
        if (countToRemove == 0) {
            return Collections.emptyList();
        }
        ArrayList<CheckpointEntry> removed = new ArrayList<CheckpointEntry>();
        Iterator iter = this.histMap.entrySet().iterator();
        while (iter.hasNext() && removed.size() < countToRemove && this.removeCheckpoint(checkpoint = (CheckpointEntry)(entry = iter.next()).getValue())) {
            removed.add(checkpoint);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCheckpoint(CheckpointEntry checkpoint) {
        if (this.wal.reserved(checkpoint.checkpointMark())) {
            U.warn(this.log, "Could not clear historyMap due to WAL reservation on cp: " + checkpoint + ", history map size is " + this.histMap.size());
            return false;
        }
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry deletedCpEntry = (CheckpointEntry)this.histMap.remove(checkpoint.timestamp());
            CheckpointEntry oldestCpInHistory = this.firstCheckpoint();
            for (Map.Entry<GroupPartitionId, CheckpointEntry> grpPartPerCp : this.earliestCp.entrySet()) {
                if (grpPartPerCp.getValue() != deletedCpEntry) continue;
                grpPartPerCp.setValue(oldestCpInHistory);
            }
        }
        return true;
    }

    public List<CheckpointEntry> onCheckpointFinished(Checkpoint chp) {
        chp.walSegsCoveredRange(this.calculateWalSegmentsCovered());
        return this.removeCheckpoints(this.isWalTruncationEnabled ? 0 : this.histMap.size() - this.maxCpHistMemSize);
    }

    private IgniteBiTuple<Long, Long> calculateWalSegmentsCovered() {
        IgniteBiTuple<Long, Long> tup = new IgniteBiTuple<Long, Long>(-1L, -1L);
        Map.Entry<Long, CheckpointEntry> lastEntry = this.histMap.lastEntry();
        if (lastEntry == null) {
            return tup;
        }
        Map.Entry<Long, CheckpointEntry> previousEntry = this.histMap.lowerEntry(lastEntry.getKey());
        WALPointer lastWALPointer = lastEntry.getValue().checkpointMark();
        long lastIdx = lastWALPointer.index();
        long prevIdx = 0L;
        if (previousEntry != null) {
            prevIdx = previousEntry.getValue().checkpointMark().index();
        }
        tup.set1(prevIdx);
        tup.set2(lastIdx - 1L);
        return tup;
    }

    @Nullable
    public WALPointer searchEarliestWalPointer(int grpId, Map<Integer, Long> partsCounter, long margin) throws IgniteCheckedException {
        if (F.isEmpty(partsCounter)) {
            return null;
        }
        HashMap<Integer, Long> modifiedPartsCounter = new HashMap<Integer, Long>(partsCounter);
        WALPointer minPtr = null;
        LinkedList<WalPointerCandidate> historyPointerCandidate = new LinkedList<WalPointerCandidate>();
        for (Long cpTs : this.checkpoints(true)) {
            CheckpointEntry cpEntry = this.entry(cpTs);
            minPtr = this.getMinimalPointer(partsCounter, margin, minPtr, historyPointerCandidate, cpEntry);
            Iterator iter = modifiedPartsCounter.entrySet().iterator();
            WALPointer ptr = cpEntry.checkpointMark();
            if (!this.wal.reserved(ptr)) {
                throw new IgniteCheckedException("WAL pointer appropriate to the checkpoint was not reserved [cp=(" + cpEntry.checkpointId() + ", " + U.format(cpEntry.timestamp()) + "), ptr=" + ptr + "]");
            }
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Long foundCntr = cpEntry.partitionCounter(this.wal, grpId, (Integer)entry.getKey());
                if (foundCntr == null || foundCntr > (Long)entry.getValue()) continue;
                iter.remove();
                if (ptr == null) {
                    throw new IgniteCheckedException("Could not find start pointer for partition [part=" + entry.getKey() + ", partCntrSince=" + entry.getValue() + "]");
                }
                if (foundCntr + margin > (Long)entry.getValue()) {
                    historyPointerCandidate.add(new WalPointerCandidate(grpId, (Integer)entry.getKey(), (Long)entry.getValue(), ptr, foundCntr));
                    continue;
                }
                partsCounter.put((Integer)entry.getKey(), (Long)entry.getValue() - margin);
                if (minPtr != null && ptr.compareTo(minPtr) >= 0) continue;
                minPtr = ptr;
            }
            if (!F.isEmpty(modifiedPartsCounter)) continue;
            break;
        }
        if (!F.isEmpty(modifiedPartsCounter)) {
            Map.Entry entry = modifiedPartsCounter.entrySet().iterator().next();
            throw new IgniteCheckedException("Could not find start pointer for partition [part=" + entry.getKey() + ", partCntrSince=" + entry.getValue() + "]");
        }
        minPtr = this.getMinimalPointer(partsCounter, margin, minPtr, historyPointerCandidate, null);
        return minPtr;
    }

    private WALPointer getMinimalPointer(Map<Integer, Long> partsCounter, long margin, WALPointer minPtr, LinkedList<WalPointerCandidate> historyPointerCandidate, CheckpointEntry cpEntry) {
        while (!F.isEmpty(historyPointerCandidate)) {
            WALPointer ptr = historyPointerCandidate.poll().choose(cpEntry, margin, partsCounter);
            if (minPtr != null && ptr.compareTo(minPtr) >= 0) continue;
            minPtr = ptr;
        }
        return minPtr;
    }

    public Map<GroupPartitionId, CheckpointEntry> searchCheckpointEntry(Map<T2<Integer, Integer>, Long> searchCntrMap) {
        if (F.isEmpty(searchCntrMap)) {
            return Collections.emptyMap();
        }
        HashMap<T2<Integer, Integer>, Long> modifiedSearchMap = new HashMap<T2<Integer, Integer>, Long>(searchCntrMap);
        HashMap<GroupPartitionId, CheckpointEntry> res = new HashMap<GroupPartitionId, CheckpointEntry>();
        for (Long cpTs : this.checkpoints(true)) {
            try {
                CheckpointEntry cpEntry = this.entry(cpTs);
                Iterator iter = modifiedSearchMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Long foundCntr = cpEntry.partitionCounter(this.wal, (Integer)((T2)entry.getKey()).get1(), (Integer)((T2)entry.getKey()).get2());
                    if (foundCntr == null || foundCntr > (Long)entry.getValue()) continue;
                    iter.remove();
                    res.put(new GroupPartitionId((Integer)((T2)entry.getKey()).get1(), (Integer)((T2)entry.getKey()).get2()), cpEntry);
                }
                if (!F.isEmpty(modifiedSearchMap)) continue;
                return res;
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Checkpoint data is unavailable in WAL [cpTs=" + U.format(cpTs) + "]", e);
                break;
            }
        }
        if (!F.isEmpty(modifiedSearchMap)) {
            return Collections.emptyMap();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointHistoryResult searchAndReserveCheckpoints(Map<Integer, Set<Integer>> groupsAndPartitions) {
        if (F.isEmpty(groupsAndPartitions) || this.reservationDisabled) {
            return new CheckpointHistoryResult(Collections.emptyMap(), null);
        }
        HashMap<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> res = new HashMap<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>>();
        CheckpointEntry oldestCpForReservation = null;
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry checkpointEntry = this.firstCheckpoint();
            for (Integer grpId : groupsAndPartitions.keySet()) {
                CheckpointEntry oldestGrpCpEntry = null;
                for (Integer part : groupsAndPartitions.get(grpId)) {
                    CheckpointEntry cpEntry = this.earliestCp.get(new GroupPartitionId(grpId, part));
                    if (cpEntry == null) continue;
                    if (oldestCpForReservation == null || oldestCpForReservation.timestamp() > cpEntry.timestamp()) {
                        oldestCpForReservation = cpEntry;
                    }
                    if (oldestGrpCpEntry == null || oldestGrpCpEntry.timestamp() > cpEntry.timestamp()) {
                        oldestGrpCpEntry = cpEntry;
                    }
                    ((Map)res.computeIfAbsent(grpId, partCpMap -> new T2(ReservationReason.NO_MORE_HISTORY, new HashMap())).get2()).put(part, cpEntry);
                }
                if (oldestGrpCpEntry != null && oldestGrpCpEntry == checkpointEntry) continue;
                res.computeIfAbsent(grpId, partCpMap -> new T2<ReservationReason, Object>(ReservationReason.CHECKPOINT_NOT_APPLICABLE, null)).set1(ReservationReason.CHECKPOINT_NOT_APPLICABLE);
            }
        }
        if (oldestCpForReservation != null && !this.wal.reserve(oldestCpForReservation.checkpointMark())) {
            this.log.warning("Could not reserve cp " + oldestCpForReservation.checkpointMark());
            for (Map.Entry entry : res.entrySet()) {
                entry.setValue(new T2<ReservationReason, Object>(ReservationReason.WAL_RESERVATION_ERROR, null));
            }
            oldestCpForReservation = null;
        }
        return new CheckpointHistoryResult(res, oldestCpForReservation);
    }

    public boolean isCheckpointApplicableForGroup(int grpId, CheckpointEntry cp) throws IgniteCheckedException {
        return !this.checkpointInapplicable.test(cp.timestamp(), grpId) && cp.groupState(this.wal).containsKey(grpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EarliestCheckpointMapSnapshot earliestCheckpointsMapSnapshot() {
        HashMap<UUID, Map<Integer, EarliestCheckpointMapSnapshot.GroupStateSnapshot>> data = new HashMap<UUID, Map<Integer, EarliestCheckpointMapSnapshot.GroupStateSnapshot>>();
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            Collection<CheckpointEntry> values = this.earliestCp.values();
            for (CheckpointEntry cp : values) {
                Map<Integer, CheckpointEntry.GroupState> map2;
                UUID checkpointId = cp.checkpointId();
                if (data.containsKey(checkpointId) || (map2 = cp.groupStates()) == null) continue;
                HashMap grpStates = new HashMap();
                map2.forEach((k, v) -> grpStates.put(k, new EarliestCheckpointMapSnapshot.GroupStateSnapshot(v.partitionIds(), v.partitionCounters(), v.size())));
                data.put(checkpointId, grpStates);
            }
        }
        Set<UUID> ids = this.histMap.values().stream().map(CheckpointEntry::checkpointId).collect(Collectors.toSet());
        return new EarliestCheckpointMapSnapshot(ids, data);
    }

    void clear() {
        this.histMap.clear();
        this.earliestCp.clear();
    }

    private class WalPointerCandidate {
        private final int grpId;
        private final int part;
        private final long partContr;
        private final WALPointer walPntr;
        private final long walPntrCntr;

        public WalPointerCandidate(int grpId, int part, long partContr, WALPointer walPntr, long walPntrCntr) {
            this.grpId = grpId;
            this.part = part;
            this.partContr = partContr;
            this.walPntr = walPntr;
            this.walPntrCntr = walPntrCntr;
        }

        public WALPointer choose(CheckpointEntry cpEntry, long margin, Map<Integer, Long> partCntsForUpdate) {
            Long foundCntr = null;
            try {
                foundCntr = cpEntry == null ? null : cpEntry.partitionCounter(CheckpointHistory.this.wal, this.grpId, this.part);
            }
            catch (IgniteCheckedException e) {
                CheckpointHistory.this.log.warning("Checkpoint cannot be chosen because counter is unavailable [grpId=" + this.grpId + ", part=" + this.part + ", cp=(" + cpEntry.checkpointId() + ", " + U.format(cpEntry.timestamp()) + ")]", e);
            }
            if (foundCntr == null || foundCntr == this.walPntrCntr) {
                partCntsForUpdate.put(this.part, this.walPntrCntr);
                return this.walPntr;
            }
            partCntsForUpdate.put(this.part, Math.max(foundCntr, this.partContr - margin));
            return cpEntry.checkpointMark();
        }
    }
}

