/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.configuration.Factory;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class CacheNearConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean nearEnabled;
    private int nearStartSize;
    private String nearEvictPlc;
    private Integer nearEvictMaxSize;

    public CacheNearConfiguration() {
    }

    public CacheNearConfiguration(CacheConfiguration ccfg) {
        this.nearEnabled = GridCacheUtils.isNearEnabled(ccfg);
        if (this.nearEnabled) {
            NearCacheConfiguration nccfg = ccfg.getNearConfiguration();
            Factory nearEvictionPlc = nccfg.getNearEvictionPolicyFactory();
            this.nearStartSize = nccfg.getNearStartSize();
            this.nearEvictPlc = VisorTaskUtils.compactClass(nearEvictionPlc);
            this.nearEvictMaxSize = VisorTaskUtils.evictionPolicyMaxSize(nearEvictionPlc);
        }
    }

    public boolean isNearEnabled() {
        return this.nearEnabled;
    }

    public int getNearStartSize() {
        return this.nearStartSize;
    }

    @Nullable
    public String getNearEvictPolicy() {
        return this.nearEvictPlc;
    }

    @Nullable
    public Integer getNearEvictMaxSize() {
        return this.nearEvictMaxSize;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.nearEnabled);
        out.writeInt(this.nearStartSize);
        U.writeString(out, this.nearEvictPlc);
        out.writeObject(this.nearEvictMaxSize);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nearEnabled = in.readBoolean();
        this.nearStartSize = in.readInt();
        this.nearEvictPlc = U.readString(in);
        this.nearEvictMaxSize = (Integer)in.readObject();
    }

    public String toString() {
        return S.toString(CacheNearConfiguration.class, this);
    }
}

