/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridMessageListenHandler;
import org.apache.ignite.internal.SecurityAwareBiPredicate;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public class IgniteMessagingImpl
extends AsyncSupportAdapter<IgniteMessaging>
implements IgniteMessaging,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;

    public IgniteMessagingImpl() {
    }

    public IgniteMessagingImpl(GridKernalContext ctx, ClusterGroupAdapter prj, boolean async) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public void send(@Nullable Object topic, Object msg) {
        this.send0(topic, msg, this.isAsync());
    }

    private void send0(@Nullable Object topic, Object msg, boolean async) throws IgniteException {
        A.notNull(msg, "msg");
        this.guard();
        try {
            Collection<ClusterNode> snapshot = this.prj.nodes();
            if (snapshot.isEmpty()) {
                throw U.emptyTopologyException();
            }
            this.ctx.io().sendUserMessage(snapshot, msg, topic, false, 0L, async);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void send(@Nullable Object topic, Collection<?> msgs) {
        this.send0(topic, msgs, this.isAsync());
    }

    private void send0(@Nullable Object topic, Collection<?> msgs, boolean async) throws IgniteException {
        A.ensure(!F.isEmpty(msgs), "msgs cannot be null or empty");
        this.guard();
        try {
            Collection<ClusterNode> snapshot = this.prj.nodes();
            if (snapshot.isEmpty()) {
                throw U.emptyTopologyException();
            }
            for (Object msg : msgs) {
                A.notNull(msg, "msg");
                this.ctx.io().sendUserMessage(snapshot, msg, topic, false, 0L, async);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void sendOrdered(@Nullable Object topic, Object msg, long timeout) {
        A.notNull(msg, "msg");
        this.guard();
        try {
            Collection<ClusterNode> snapshot = this.prj.nodes();
            if (snapshot.isEmpty()) {
                throw U.emptyTopologyException();
            }
            if (timeout == 0L) {
                timeout = this.ctx.config().getNetworkTimeout();
            }
            this.ctx.io().sendUserMessage(snapshot, msg, topic, true, timeout, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void localListen(@Nullable Object topic, IgniteBiPredicate<UUID, ?> p) {
        A.notNull(p, "p");
        this.guard();
        try {
            this.ctx.io().addUserMessageListener(topic, p);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void stopLocalListen(@Nullable Object topic, IgniteBiPredicate<UUID, ?> p) {
        A.notNull(p, "p");
        this.guard();
        try {
            this.ctx.io().removeUserMessageListener(topic, p);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public UUID remoteListen(@Nullable Object topic, IgniteBiPredicate<UUID, ?> p) {
        A.notNull(p, "p");
        this.guard();
        try {
            GridMessageListenHandler hnd = new GridMessageListenHandler(topic, this.securityAwareBiPredicate(p));
            UUID uUID = this.saveOrGet(this.ctx.continuous().startRoutine(hnd, false, 1, 0L, false, this.prj.predicate()));
            return uUID;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    private IgniteBiPredicate<UUID, Object> securityAwareBiPredicate(IgniteBiPredicate<UUID, ?> p) {
        IgniteBiPredicate<UUID, Object> res = p;
        if (this.ctx.security().enabled()) {
            UUID subjId = this.ctx.security().securityContext().subject().id();
            return new SecurityAwareBiPredicate<UUID, Object>(subjId, res);
        }
        return res;
    }

    @Override
    public IgniteFuture<UUID> remoteListenAsync(@Nullable Object topic, IgniteBiPredicate<UUID, ?> p) throws IgniteException {
        A.notNull(p, "p");
        this.guard();
        try {
            GridMessageListenHandler hnd = new GridMessageListenHandler(topic, this.securityAwareBiPredicate(p));
            IgniteFutureImpl<UUID> igniteFutureImpl = new IgniteFutureImpl<UUID>(this.ctx.continuous().startRoutine(hnd, false, 1, 0L, false, this.prj.predicate()));
            return igniteFutureImpl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void stopRemoteListen(UUID opId) {
        A.notNull(opId, "opId");
        this.guard();
        try {
            this.saveOrGet(this.ctx.continuous().stopRoutine(opId));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> stopRemoteListenAsync(UUID opId) throws IgniteException {
        A.notNull(opId, "opId");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.continuous().stopRoutine(opId));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    protected IgniteMessaging createAsyncInstance() {
        return new IgniteMessagingImpl(this.ctx, this.prj, true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.prj.message();
    }
}

