/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rex.RexBuilder;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.calcite.metadata.IgniteMetadata;
import org.apache.ignite.internal.processors.query.calcite.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappingQueryContext
implements Context {
    private final Context parent;
    private final UUID locNodeId;
    private final AffinityTopologyVersion topVer;
    private final Map<String, Object> params;
    private RelOptCluster cluster;

    public MappingQueryContext(UUID locNodeId, AffinityTopologyVersion topVer) {
        this(null, locNodeId, topVer, null);
    }

    public MappingQueryContext(BaseQueryContext parent, UUID locNodeId, AffinityTopologyVersion topVer, Map<String, Object> params) {
        this.locNodeId = locNodeId;
        this.topVer = topVer;
        this.parent = parent;
        this.params = !F.isEmpty(params) ? Collections.unmodifiableMap(params) : Collections.emptyMap();
    }

    public UUID localNodeId() {
        return this.locNodeId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean isLocal() {
        BaseQueryContext qryCtx = this.unwrap(BaseQueryContext.class);
        return qryCtx != null && qryCtx.isLocal();
    }

    public int[] partitions() {
        BaseQueryContext qryCtx = this.unwrap(BaseQueryContext.class);
        return qryCtx != null ? qryCtx.partitions() : null;
    }

    public Map<String, Object> queryParameters() {
        return this.params;
    }

    public IgniteTypeFactory typeFactory() {
        BaseQueryContext qryCtx = this.unwrap(BaseQueryContext.class);
        return qryCtx != null ? qryCtx.typeFactory() : BaseQueryContext.TYPE_FACTORY;
    }

    RelOptCluster cluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)Commons.emptyCluster().getPlanner(), (RexBuilder)Commons.emptyCluster().getRexBuilder());
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, Commons.emptyCluster().getPlanner()));
            this.cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        }
        return this.cluster;
    }

    public <C> @Nullable C unwrap(Class<C> aCls) {
        if (aCls == this.getClass()) {
            return aCls.cast(this);
        }
        return (C)(this.parent != null ? this.parent.unwrap(aCls) : null);
    }
}

