/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing.opencensus;

import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.tracing.TracingSpiType;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.tracing.TracingSpi;
import org.apache.ignite.spi.tracing.opencensus.OpenCensusSpanAdapter;
import org.apache.ignite.spi.tracing.opencensus.OpenCensusTraceExporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=true)
public class OpenCensusTracingSpi
extends IgniteSpiAdapter
implements TracingSpi<OpenCensusSpanAdapter> {
    private final List<OpenCensusTraceExporter> exporters;
    private final boolean externalProvider;

    public OpenCensusTracingSpi() {
        this.exporters = null;
        this.externalProvider = true;
    }

    public OpenCensusTracingSpi(SpanExporter.Handler ... exporters) {
        this.exporters = Arrays.stream(exporters).map(OpenCensusTraceExporter::new).collect(Collectors.toList());
        this.externalProvider = false;
    }

    public OpenCensusSpanAdapter create(@NotNull String name, @Nullable byte[] parentSerializedSpan) throws Exception {
        return new OpenCensusSpanAdapter(Tracing.getTracer().spanBuilderWithRemoteParent(name, Tracing.getPropagationComponent().getBinaryFormat().fromByteArray(parentSerializedSpan)).setSampler(Samplers.alwaysSample()).startSpan());
    }

    @NotNull
    public OpenCensusSpanAdapter create(@NotNull String name, @Nullable OpenCensusSpanAdapter parentSpan) {
        try {
            Span openCensusParent = null;
            if (parentSpan != null) {
                openCensusParent = parentSpan.impl();
            }
            return new OpenCensusSpanAdapter(Tracing.getTracer().spanBuilderWithExplicitParent(name, openCensusParent).setSampler(Samplers.alwaysSample()).startSpan());
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to create span from parent [spanName=" + name + ", parentSpan=" + parentSpan + "]", (Throwable)e);
        }
    }

    public byte[] serialize(@NotNull OpenCensusSpanAdapter span) {
        return Tracing.getPropagationComponent().getBinaryFormat().toByteArray(span.impl().getContext());
    }

    public String getName() {
        return "OpenCensusTracingSpi";
    }

    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        if (!this.externalProvider && this.exporters != null) {
            for (OpenCensusTraceExporter exporter : this.exporters) {
                exporter.start(igniteInstanceName);
            }
        }
    }

    public void spiStop() throws IgniteSpiException {
        if (!this.externalProvider && this.exporters != null) {
            for (OpenCensusTraceExporter exporter : this.exporters) {
                exporter.stop();
            }
        }
    }

    public byte type() {
        return TracingSpiType.OPEN_CENSUS_TRACING_SPI.index();
    }
}

