/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BenchmarkConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    @Parameter(names={"-cfg", "--config"}, description="Framework configuration file path")
    private String propsFileName = "config/benchmark.properties";
    @Parameter(names={"--logsFolder"}, description="Logs directory")
    private String logsFolder;
    @Parameter(names={"--currentFolder"}, description="Current folder")
    private String curFolder;
    @Parameter(names={"--scriptsFolder"}, description="Script folder")
    private String scriptsFolder;
    @Parameter(names={"-dn", "--driverNames"}, variableArity=true, description="Space-separated list of Benchmark driver names (required)")
    private List<String> driverNames;
    @Parameter(names={"-sn", "--serverName"}, description="Benchmark server name (required)")
    private String serverName;
    @Parameter(names={"-id", "--memberId"}, description="Memebr ID")
    private int memberId = -1;
    @Parameter(names={"-p", "--packages"}, description="Comma separated list of packages for benchmarks")
    private List<String> packages = Collections.emptyList();
    @Parameter(names={"-pr", "--probes"}, description="Comma separated list of probes for benchmarks")
    private List<String> dfltProbeClsNames = Collections.emptyList();
    @Parameter(names={"wr", "--writer"}, description="Probe point writer class name")
    private String probeWriter;
    @Parameter(names={"-t", "--threads"}, description="Thread count (set to 'cpus * 2')")
    private int threads = Runtime.getRuntime().availableProcessors() * 2;
    @Parameter(names={"-d", "--duration"}, description="Duration, in seconds")
    private long duration = 40L;
    @Parameter(names={"-w", "--warmup"}, description="Warmup, in seconds")
    private long warmup = 20L;
    @Parameter(names={"-ops", "--operations"}, description="Operations (0 is infinite, default)")
    private int opsCnt;
    @Parameter(names={"-sh", "--shutdown"}, description="Invoke shutdown hook")
    private boolean shutdownHook = true;
    @Parameter(names={"-of", "--outputFolder"}, description="Output folder for benchmark results")
    private String outputFolder;
    @Parameter(names={"-ds", "--descriptions"}, variableArity=true, description="Space-separated list of benchmark run descriptions")
    private List<String> descs;
    @Parameter(names={"-hn", "--hostName"}, description="Host name where a benchmark driver is run")
    private String hostName = "";
    @Parameter(names={"-remoteuser", "--remoteuser"}, description="Remote user name")
    private String remoteUser = "";
    @Parameter(names={"-rhn", "--remoteHostName"}, description="Remote host name")
    private String remoteHostName = "";
    @Parameter(names={"-lfreq", "--logFreq"}, description="Iterations log frequency")
    private int logIterFreq = 25000;
    @Parameter(names={"-h", "--help"}, description="Print help message", help=true, hidden=true)
    private boolean help;
    private String[] cmdArgs;
    private Map<String, String> customProps;
    private transient PrintStream outputWriter;
    private transient PrintStream errorWriter;

    public String propertiesFileName() {
        return this.propsFileName;
    }

    public boolean help() {
        return this.help;
    }

    public String serverName() {
        return this.serverName;
    }

    public List<String> driverNames() {
        return this.driverNames;
    }

    public int memberId() {
        return this.memberId;
    }

    public List<String> packages() {
        return this.packages;
    }

    public void packages(List<String> packages) {
        this.packages = packages;
    }

    public int threads() {
        return this.threads;
    }

    public void threads(int threads) {
        this.threads = threads;
    }

    public long duration() {
        return this.duration;
    }

    public void duration(long duration) {
        this.duration = duration;
    }

    public int operationsCount() {
        return this.opsCnt;
    }

    public void operationsCount(int opsCnt) {
        this.opsCnt = opsCnt;
    }

    public int logIterationsFrequency() {
        return this.logIterFreq;
    }

    public long warmup() {
        return this.warmup;
    }

    public void warmup(long warmup) {
        this.warmup = warmup;
    }

    public boolean shutdownHook() {
        return this.shutdownHook;
    }

    public void shutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public Map<String, String> customProperties() {
        return this.customProps;
    }

    public void customProperties(Map<String, String> customProps) {
        this.customProps = customProps;
    }

    public PrintStream output() {
        return this.outputWriter;
    }

    public void output(PrintStream outputWriter) {
        this.outputWriter = outputWriter;
    }

    public PrintStream error() {
        return this.errorWriter;
    }

    public void error(PrintStream errorWriter) {
        this.errorWriter = errorWriter;
    }

    public String[] commandLineArguments() {
        return this.cmdArgs;
    }

    public void commandLineArguments(String[] cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public List<String> defaultProbeClassNames() {
        return this.dfltProbeClsNames;
    }

    public void defaultProbeClassNames(List<String> dfltProbeClsNames) {
        this.dfltProbeClsNames = dfltProbeClsNames;
    }

    public String probeWriterClassName() {
        return this.probeWriter;
    }

    public void probeWriterClassName(String probeWriter) {
        this.probeWriter = probeWriter;
    }

    public String scriptsFolder() {
        return this.scriptsFolder;
    }

    public String currentFolder() {
        return this.curFolder;
    }

    public String logsFolder() {
        return this.logsFolder;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public List<String> descriptions() {
        return this.descs;
    }

    public String hostName() {
        return this.hostName;
    }

    public String remoteUser() {
        return this.remoteUser;
    }

    public void remoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String remoteHostName() {
        return this.remoteHostName;
    }

    public void remoteHostName(String remoteHostName) {
        this.remoteHostName = remoteHostName;
    }

    public String defaultDescription() {
        return "-t=" + this.threads + "-d=" + this.duration + "-w=" + this.warmup;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + "memberId='" + this.memberId + '\'' + ", driverNames='" + this.driverNames + '\'' + ", serverName='" + this.serverName + '\'' + ", threads=" + this.threads + ", duration=" + this.duration + ", warmup=" + this.warmup + ", dfltProbeClsNames=" + this.dfltProbeClsNames + ", propsFileName='" + this.propsFileName + '\'' + ", packages=" + this.packages + ", cmdArgs=" + Arrays.toString(this.cmdArgs) + ", probeWriter='" + this.probeWriter + '\'' + ", customProps=" + this.customProps + ", shutdownHook=" + this.shutdownHook + ", currentFolder=" + this.curFolder + ", scriptsFolder=" + this.scriptsFolder + ", logsFolder=" + this.logsFolder + ", outputFolder=" + this.outputFolder + ", outputWriter=" + this.outputWriter + ", errorWriter=" + this.errorWriter + ", descriptions=" + this.descs + ", hostName=" + this.hostName + ']';
    }
}

