/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.guacamole.tunnel.InterceptedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptedStreamMap<T extends Closeable> {
    private static final Logger logger = LoggerFactory.getLogger(InterceptedStreamMap.class);
    private static final long STREAM_WAIT_TIMEOUT = 1000L;
    private final ConcurrentMap<String, InterceptedStream<T>> streams = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(T stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.warn("Unable to close intercepted stream: {}", (Object)e.getMessage());
            logger.debug("I/O error prevented closure of intercepted stream.", (Throwable)e);
        }
        T t = stream;
        synchronized (t) {
            stream.notify();
        }
    }

    public InterceptedStream<T> close(String index) {
        InterceptedStream stream = (InterceptedStream)this.streams.remove(index);
        if (stream == null) {
            return null;
        }
        this.close(stream.getStream());
        return stream;
    }

    public boolean close(InterceptedStream<T> stream) {
        boolean wasRemoved = this.streams.remove(stream.getIndex(), stream);
        this.close(stream.getStream());
        return wasRemoved;
    }

    public void closeAll() {
        for (InterceptedStream stream : this.streams.values()) {
            this.close(stream.getStream());
        }
        this.streams.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(InterceptedStream<T> stream) {
        Closeable underlyingStream;
        Closeable closeable = underlyingStream = stream.getStream();
        synchronized (closeable) {
            while (this.streams.get(stream.getIndex()) == stream) {
                try {
                    underlyingStream.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public InterceptedStream<T> get(String index) {
        return (InterceptedStream)this.streams.get(index);
    }

    public void put(InterceptedStream<T> stream) {
        InterceptedStream<T> oldStream = this.streams.put(stream.getIndex(), stream);
        if (oldStream != null) {
            this.close(oldStream.getStream());
        }
    }
}

