/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.utils;

import io.github.ollama4j.utils.Options;
import java.util.HashMap;

public class OptionsBuilder {
    private final Options options = new Options(new HashMap<String, Object>());

    public OptionsBuilder setMirostat(int value) {
        this.options.getOptionsMap().put("mirostat", value);
        return this;
    }

    public OptionsBuilder setMirostatEta(float value) {
        this.options.getOptionsMap().put("mirostat_eta", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setMirostatTau(float value) {
        this.options.getOptionsMap().put("mirostat_tau", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setNumCtx(int value) {
        this.options.getOptionsMap().put("num_ctx", value);
        return this;
    }

    public OptionsBuilder setNumGqa(int value) {
        this.options.getOptionsMap().put("num_gqa", value);
        return this;
    }

    public OptionsBuilder setNumGpu(int value) {
        this.options.getOptionsMap().put("num_gpu", value);
        return this;
    }

    public OptionsBuilder setNumThread(int value) {
        this.options.getOptionsMap().put("num_thread", value);
        return this;
    }

    public OptionsBuilder setRepeatLastN(int value) {
        this.options.getOptionsMap().put("repeat_last_n", value);
        return this;
    }

    public OptionsBuilder setRepeatPenalty(float value) {
        this.options.getOptionsMap().put("repeat_penalty", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setTemperature(float value) {
        this.options.getOptionsMap().put("temperature", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setSeed(int value) {
        this.options.getOptionsMap().put("seed", value);
        return this;
    }

    public OptionsBuilder setStop(String value) {
        this.options.getOptionsMap().put("stop", value);
        return this;
    }

    public OptionsBuilder setTfsZ(float value) {
        this.options.getOptionsMap().put("tfs_z", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setNumPredict(int value) {
        this.options.getOptionsMap().put("num_predict", value);
        return this;
    }

    public OptionsBuilder setTopK(int value) {
        this.options.getOptionsMap().put("top_k", value);
        return this;
    }

    public OptionsBuilder setTopP(float value) {
        this.options.getOptionsMap().put("top_p", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setMinP(float value) {
        this.options.getOptionsMap().put("min_p", Float.valueOf(value));
        return this;
    }

    public OptionsBuilder setCustomOption(String name, Object value) throws IllegalArgumentException {
        if (!(value instanceof Integer || value instanceof Float || value instanceof String)) {
            throw new IllegalArgumentException("Invalid type for parameter. Allowed types are: Integer, Float, or String.");
        }
        this.options.getOptionsMap().put(name, value);
        return this;
    }

    public Options build() {
        return this.options;
    }
}

