/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.externals.reference;

import com.google.common.collect.Lists;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.clients.ExternCConfiguration;
import org.apache.flex.compiler.internal.codegen.externals.reference.BaseReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ClassReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ParameterReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;
import org.apache.flex.compiler.internal.codegen.externals.utils.FunctionUtils;

public class FunctionReference
extends BaseReference {
    private boolean isStatic;
    private Node paramNode;
    private Set<String> imports = new HashSet<String>();
    private List<ParameterReference> parameters;

    public File getFile(File asSourceRoot) {
        String packageName = "";
        return new File(asSourceRoot, packageName + File.separator + this.getQualifiedName() + ".as");
    }

    private FunctionReference getContext() {
        return this;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public FunctionReference(ReferenceModel model, Node node, String qualifiedName, JSDocInfo comment) {
        super(model, node, qualifiedName, comment);
        this.paramNode = node.getChildAtIndex(1);
        this.addParameterReferences();
    }

    private void addParameterReferences() {
        this.parameters = new ArrayList<ParameterReference>();
        if (this.paramNode != null) {
            boolean isDocumented = this.comment.getParameterCount() > 0;
            ArrayList parameterNames = null;
            if (isDocumented) {
                parameterNames = Lists.newArrayList((Iterable)this.comment.getParameterNames());
            }
            for (Node param : this.paramNode.children()) {
                ParameterReference parameterReference;
                if (parameterNames != null && parameterNames.contains(param.getString())) {
                    String qualifiedName = FunctionUtils.toParameterType(this, param.getString());
                    parameterReference = new ParameterReference(this.getModel(), param, qualifiedName);
                } else {
                    parameterReference = new ParameterReference(this.getModel(), param);
                }
                this.parameters.add(parameterReference);
            }
        }
    }

    @Override
    public void emit(StringBuilder sb) {
        String packageName = "";
        sb.append("package ");
        sb.append(packageName).append(" ");
        sb.append("{\n");
        sb.append("\n");
        this.printImports(sb);
        this.emitComment(sb);
        ExternCConfiguration.ExcludedMember excluded = this.isExcluded();
        if (excluded != null) {
            excluded.print(sb);
        }
        String staticValue = this.isStatic ? "static " : "";
        String publicModifier = "public ";
        String returns = "";
        if (!this.transformReturnString().equals("void")) {
            returns = " return null;";
        }
        String braces = " { " + returns + " }";
        sb.append("    ");
        sb.append(publicModifier);
        sb.append(staticValue);
        sb.append("function ");
        sb.append(this.getQualifiedName());
        sb.append(this.toParameterString());
        sb.append(":");
        sb.append(this.transformReturnString());
        sb.append(braces);
        sb.append("\n");
        sb.append("}\n");
    }

    private void printImports(StringBuilder sb) {
        if (this.imports.size() > 0) {
            for (String anImport : this.imports) {
                sb.append("import ").append(anImport).append(";\n");
            }
            sb.append("\n");
        }
    }

    public String transformReturnString() {
        return FunctionUtils.toReturnString(this.getContext());
    }

    private String toParameterString() {
        return FunctionUtils.toParameterString(this.getContext(), this.getComment(), this.paramNode, this.outputJS);
    }

    public boolean isOverride() {
        return this.getComment().isOverride();
    }

    @Override
    protected void emitCommentBody(StringBuilder sb) {
        this.emitFunctionCommentBody(sb);
    }

    public void addImport(ClassReference reference) {
        if (reference != null) {
            this.imports.add(reference.getQualifiedName());
        }
    }

    public List<ParameterReference> getParameters() {
        return this.parameters;
    }

    public boolean hasImport(String qualifiedName) {
        return this.imports.contains(qualifiedName);
    }
}

