/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.List;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class PwPolicyMgrRestImpl
extends Manageable
implements PwPolicyMgr {
    private static final String CLS_NM = PwPolicyMgrRestImpl.class.getName();

    @Override
    public void add(PwPolicy policy) throws SecurityException {
        VUtil.assertNotNull(policy, 4023, CLS_NM + ".add");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(policy);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void update(PwPolicy policy) throws SecurityException {
        VUtil.assertNotNull(policy, 4023, CLS_NM + ".update");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(policy);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void delete(PwPolicy policy) throws SecurityException {
        VUtil.assertNotNull(policy, 4022, CLS_NM + ".delete");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(policy);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public PwPolicy read(String name) throws SecurityException {
        VUtil.assertNotNullOrEmpty(name, 4022, CLS_NM + ".read");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(new PwPolicy(name));
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PwPolicy retPolicy = (PwPolicy)response.getEntity();
        return retPolicy;
    }

    @Override
    public List<PwPolicy> search(String searchVal) throws SecurityException {
        VUtil.assertNotNull(searchVal, 4022, CLS_NM + ".search");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(new PwPolicy(searchVal));
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<PwPolicy> retPolicies = response.getEntities();
        return retPolicies;
    }

    @Override
    public void updateUserPolicy(String userId, String name) throws SecurityException {
        String methodName = "updateUserPolicy";
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + "." + methodName);
        VUtil.assertNotNullOrEmpty(name, 4022, CLS_NM + "." + methodName);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(new PwPolicy(name));
        request.setValue(userId);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdUserAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deletePasswordPolicy(String userId) throws SecurityException {
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + ".deletePasswordPolicy");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setValue(userId);
        if (this.adminSess != null) {
            // empty if block
        }
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "pswdUserDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

