/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.DelAccessMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.DelAccessMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class DelAccessMgrFactory {
    private static final String CLS_NM = DelAccessMgrFactory.class.getName();

    public static DelAccessMgr createInstance() throws SecurityException {
        return DelAccessMgrFactory.createInstance("HOME");
    }

    public static DelAccessMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String accessClassName = Config.getInstance().getProperty("delegated.accessmgr.implementation");
        Manageable accessMgr = StringUtils.isEmpty((CharSequence)accessClassName) ? (Config.getInstance().isRestEnabled() ? new DelAccessMgrRestImpl() : new DelAccessMgrImpl()) : (DelAccessMgr)ClassUtil.createInstance(accessClassName);
        accessMgr.setContextId(contextId);
        return accessMgr;
    }

    public static DelAccessMgr createInstance(Session adminSess) throws SecurityException {
        return DelAccessMgrFactory.createInstance("HOME", adminSess);
    }

    public static DelAccessMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance(contextId);
        accessMgr.setAdmin(adminSess);
        return accessMgr;
    }
}

