/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AuthZ;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuditUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditUtils.class.getName());

    private AuditUtils() {
    }

    static Permission getAuthZPerm(String raw) {
        int eindx;
        Permission perm = new Permission();
        int bindx = raw.indexOf("ftObjId");
        if (bindx != -1 && (eindx = raw.indexOf(43)) != -1) {
            perm.setObjId(raw.substring(bindx + "ftObjId".length() + 1, eindx));
        }
        if ((bindx = raw.indexOf("ftObjNm")) != -1 && (eindx = raw.substring(bindx).indexOf(",")) != -1) {
            perm.setObjName(raw.substring(bindx + "ftObjNm".length() + 1, eindx += bindx));
        }
        if ((bindx = raw.indexOf("ftOpNm")) != -1 && (eindx = raw.substring(bindx).indexOf(44)) != -1) {
            perm.setOpName(raw.substring(bindx + "ftOpNm".length() + 1, eindx += bindx));
        }
        return perm;
    }

    static void mapAuthZPerm(AuthZ authZ) {
        int eindx;
        String raw = authZ.getReqDN();
        int bindx = raw.indexOf("ftObjId");
        if (bindx != -1 && (eindx = raw.indexOf(43)) != -1) {
            authZ.setReqDerefAliases(raw.substring(bindx + "ftObjId".length() + 1, eindx));
        }
        if ((bindx = raw.indexOf("ftObjNm")) != -1 && (eindx = raw.substring(bindx).indexOf(44)) != -1) {
            authZ.setReqAttr(raw.substring(bindx + "ftObjNm".length() + 1, eindx += bindx));
        }
        if ((bindx = raw.indexOf("ftOpNm")) != -1 && (eindx = raw.substring(bindx).indexOf(44)) != -1) {
            authZ.setReqAttrsOnly(raw.substring(bindx + "ftOpNm".length() + 1, eindx += bindx));
        }
    }

    static String getAuthZId(String inputString) {
        String val;
        int indx;
        StringTokenizer maxTkn;
        String userId = null;
        if (inputString != null && inputString.length() > 0 && (maxTkn = new StringTokenizer(inputString, ",")).countTokens() > 0 && (indx = (val = maxTkn.nextToken()).indexOf(61)) >= 1) {
            userId = val.substring(indx + 1);
        }
        return userId;
    }

    static User getUser(ReviewMgr reviewMgr, String userId) {
        User user = null;
        try {
            user = reviewMgr.readUser(new User(userId));
        }
        catch (SecurityException se) {
            String error = "SecurityException=" + se;
            LOG.warn(error);
        }
        return user;
    }

    static User getUserByInternalId(ReviewMgr reviewMgr, String internalId) {
        User user = null;
        try {
            User inUser = new User();
            inUser.setInternalId(internalId);
            List users = reviewMgr.findUsers(inUser);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                if (users.size() > 1) {
                    String error = "Found: " + users.size() + " users matching internalId: " + internalId;
                    LOG.warn(error);
                }
                user = (User)users.get(0);
            } else {
                String error = "Can't find user matching internalId: " + internalId;
                LOG.warn(error);
            }
        }
        catch (SecurityException se) {
            String error = "SecurityException=" + se;
            LOG.warn(error);
        }
        return user;
    }
}

